/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.network.DemandForwardingBridgeSupport;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.util.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemandForwardingBridge
extends DemandForwardingBridgeSupport {
    private static final Logger LOG = LoggerFactory.getLogger(DemandForwardingBridge.class);
    protected final BrokerId[] remoteBrokerPath = new BrokerId[]{null};
    protected Object brokerInfoMutex = new Object();
    protected BrokerId remoteBrokerId;

    public DemandForwardingBridge(NetworkBridgeConfiguration configuration, Transport localBroker, Transport remoteBroker) {
        super(configuration, localBroker, remoteBroker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void serviceRemoteBrokerInfo(Command command) throws IOException {
        Object object = this.brokerInfoMutex;
        synchronized (object) {
            BrokerInfo remoteBrokerInfo = (BrokerInfo)command;
            this.remoteBrokerPath[0] = this.remoteBrokerId = remoteBrokerInfo.getBrokerId();
            this.remoteBrokerName = remoteBrokerInfo.getBrokerName();
            if (this.localBrokerId != null && this.localBrokerId.equals(this.remoteBrokerId)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this.configuration.getBrokerName() + " disconnecting remote loop back connection: " + this.remoteBrokerName);
                }
                ServiceSupport.dispose(this);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("counting down remoteBrokerNameKnownLatch with: " + command);
            }
            this.remoteBrokerNameKnownLatch.countDown();
        }
    }

    @Override
    protected void addRemoteBrokerToBrokerPath(ConsumerInfo info) {
        info.setBrokerPath(this.appendToBrokerPath(info.getBrokerPath(), this.getRemoteBrokerPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void serviceLocalBrokerInfo(Command command) throws InterruptedException {
        Object object = this.brokerInfoMutex;
        synchronized (object) {
            this.localBrokerPath[0] = this.localBrokerId = ((BrokerInfo)command).getBrokerId();
            this.localBrokerIdKnownLatch.countDown();
            if (this.remoteBrokerId != null && this.remoteBrokerId.equals(this.localBrokerId)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this.configuration.getBrokerName() + " disconnecting local loop back connection.");
                }
                this.waitStarted();
                ServiceSupport.dispose(this);
            }
        }
    }

    @Override
    protected BrokerId[] getRemoteBrokerPath() {
        return this.remoteBrokerPath;
    }
}

