/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.jdbc.TransactionContext;
import org.apache.activemq.store.jdbc.adapter.DefaultJDBCAdapter;
import org.apache.activemq.util.ByteArrayOutputStream;

public class BlobJDBCAdapter
extends DefaultJDBCAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAddMessage(TransactionContext c, long sequence, MessageId messageID, ActiveMQDestination destination, byte[] data, long expiration, byte priority) throws SQLException, IOException {
        PreparedStatement s = null;
        ResultSet rs = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getAddMessageStatement());
            s.setLong(1, sequence);
            s.setString(2, messageID.getProducerId().toString());
            s.setLong(3, messageID.getProducerSequenceId());
            s.setString(4, destination.getQualifiedName());
            s.setLong(5, expiration);
            s.setLong(6, priority);
            s.setString(7, " ");
            if (s.executeUpdate() != 1) {
                throw new IOException("Failed to add broker message: " + messageID + " in container.");
            }
            s.close();
            s = c.getConnection().prepareStatement(this.statements.getFindMessageByIdStatement());
            s.setLong(1, sequence);
            rs = s.executeQuery();
            if (!rs.next()) {
                throw new IOException("Failed select blob for message: " + messageID + " in container.");
            }
            Blob blob = rs.getBlob(1);
            OutputStream stream = blob.setBinaryStream(data.length);
            stream.write(data);
            stream.close();
            s.close();
            s = c.getConnection().prepareStatement(this.statements.getUpdateMessageStatement());
            s.setBlob(1, blob);
            s.setLong(2, sequence);
            this.cleanupExclusiveLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            this.cleanupExclusiveLock.readLock().unlock();
            BlobJDBCAdapter.close(rs);
            BlobJDBCAdapter.close(s);
            throw throwable;
        }
        BlobJDBCAdapter.close(rs);
        BlobJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] doGetMessage(TransactionContext c, MessageId id) throws SQLException, IOException {
        byte[] byArray;
        ResultSet rs;
        PreparedStatement s;
        block4: {
            s = null;
            rs = null;
            this.cleanupExclusiveLock.readLock().lock();
            s = c.getConnection().prepareStatement(this.statements.getFindMessageStatement());
            s.setString(1, id.getProducerId().toString());
            s.setLong(2, id.getProducerSequenceId());
            rs = s.executeQuery();
            if (rs.next()) break block4;
            byte[] byArray2 = null;
            this.cleanupExclusiveLock.readLock().unlock();
            BlobJDBCAdapter.close(rs);
            BlobJDBCAdapter.close(s);
            return byArray2;
        }
        try {
            int ch;
            Blob blob = rs.getBlob(1);
            InputStream is = blob.getBinaryStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream((int)blob.length());
            while ((ch = is.read()) >= 0) {
                os.write(ch);
            }
            is.close();
            os.close();
            byArray = os.toByteArray();
            this.cleanupExclusiveLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            this.cleanupExclusiveLock.readLock().unlock();
            BlobJDBCAdapter.close(rs);
            BlobJDBCAdapter.close(s);
            throw throwable;
        }
        BlobJDBCAdapter.close(rs);
        BlobJDBCAdapter.close(s);
        return byArray;
    }
}

