/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.advisory;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.TopicSubscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.security.SecurityContext;
import org.apache.activemq.state.ProducerState;
import org.apache.activemq.usage.Usage;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.LongSequenceGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvisoryBroker
extends BrokerFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AdvisoryBroker.class);
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    protected final ConcurrentHashMap<ConnectionId, ConnectionInfo> connections = new ConcurrentHashMap();
    protected final ConcurrentHashMap<ConsumerId, ConsumerInfo> consumers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<ProducerId, ProducerInfo> producers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<ActiveMQDestination, DestinationInfo> destinations = new ConcurrentHashMap();
    protected final ProducerId advisoryProducerId = new ProducerId();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();

    public AdvisoryBroker(Broker next) {
        super(next);
        this.advisoryProducerId.setConnectionId(ID_GENERATOR.generateId());
    }

    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        super.addConnection(context, info);
        ActiveMQTopic topic = AdvisorySupport.getConnectionAdvisoryTopic();
        ConnectionInfo copy = info.copy();
        copy.setUserName("");
        copy.setPassword("");
        this.fireAdvisory(context, topic, copy);
        this.connections.put(copy.getConnectionId(), copy);
    }

    @Override
    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        Subscription answer = super.addConsumer(context, info);
        if (!AdvisorySupport.isAdvisoryTopic(info.getDestination())) {
            ActiveMQTopic topic = AdvisorySupport.getConsumerAdvisoryTopic(info.getDestination());
            this.consumers.put(info.getConsumerId(), info);
            this.fireConsumerAdvisory(context, info.getDestination(), topic, info);
        } else {
            ActiveMQTopic topic;
            if (AdvisorySupport.isConnectionAdvisoryTopic(info.getDestination())) {
                for (ConnectionInfo connectionInfo : this.connections.values()) {
                    topic = AdvisorySupport.getConnectionAdvisoryTopic();
                    this.fireAdvisory(context, topic, connectionInfo, info.getConsumerId());
                }
            }
            if (AdvisorySupport.isDestinationAdvisoryTopic(info.getDestination())) {
                for (DestinationInfo destinationInfo : this.destinations.values()) {
                    topic = AdvisorySupport.getDestinationAdvisoryTopic(destinationInfo.getDestination());
                    this.fireAdvisory(context, topic, destinationInfo, info.getConsumerId());
                }
            }
            if (AdvisorySupport.isProducerAdvisoryTopic(info.getDestination())) {
                for (ProducerInfo producerInfo : this.producers.values()) {
                    topic = AdvisorySupport.getProducerAdvisoryTopic(producerInfo.getDestination());
                    this.fireProducerAdvisory(context, producerInfo.getDestination(), topic, producerInfo, info.getConsumerId());
                }
            }
            if (AdvisorySupport.isConsumerAdvisoryTopic(info.getDestination())) {
                for (ConsumerInfo consumerInfo : this.consumers.values()) {
                    topic = AdvisorySupport.getConsumerAdvisoryTopic(consumerInfo.getDestination());
                    this.fireConsumerAdvisory(context, consumerInfo.getDestination(), topic, consumerInfo, info.getConsumerId());
                }
            }
        }
        return answer;
    }

    @Override
    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        super.addProducer(context, info);
        if (info.getDestination() != null && !AdvisorySupport.isAdvisoryTopic(info.getDestination())) {
            ActiveMQTopic topic = AdvisorySupport.getProducerAdvisoryTopic(info.getDestination());
            this.fireProducerAdvisory(context, info.getDestination(), topic, info);
            this.producers.put(info.getProducerId(), info);
        }
    }

    @Override
    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination, boolean create) throws Exception {
        DestinationInfo info;
        DestinationInfo previous;
        Destination answer = super.addDestination(context, destination, create);
        if (!AdvisorySupport.isAdvisoryTopic(destination) && (previous = this.destinations.putIfAbsent(destination, info = new DestinationInfo(context.getConnectionId(), 0, destination))) == null) {
            ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic(destination);
            this.fireAdvisory(context, topic, info);
        }
        return answer;
    }

    @Override
    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        DestinationInfo previous;
        ActiveMQDestination destination = info.getDestination();
        this.next.addDestinationInfo(context, info);
        if (!AdvisorySupport.isAdvisoryTopic(destination) && (previous = this.destinations.putIfAbsent(destination, info)) == null) {
            ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic(destination);
            this.fireAdvisory(context, topic, info);
        }
    }

    @Override
    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Exception {
        super.removeDestination(context, destination, timeout);
        DestinationInfo info = this.destinations.remove(destination);
        if (info != null) {
            info.setDestination(destination);
            info.setOperationType((byte)1);
            ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic(destination);
            this.fireAdvisory(context, topic, info);
            try {
                this.next.removeDestination(context, AdvisorySupport.getConsumerAdvisoryTopic(info.getDestination()), -1L);
            }
            catch (Exception expectedIfDestinationDidNotExistYet) {
                // empty catch block
            }
            try {
                this.next.removeDestination(context, AdvisorySupport.getProducerAdvisoryTopic(info.getDestination()), -1L);
            }
            catch (Exception expectedIfDestinationDidNotExistYet) {
                // empty catch block
            }
        }
    }

    @Override
    public void removeDestinationInfo(ConnectionContext context, DestinationInfo destInfo) throws Exception {
        super.removeDestinationInfo(context, destInfo);
        DestinationInfo info = this.destinations.remove(destInfo.getDestination());
        if (info != null) {
            info.setDestination(destInfo.getDestination());
            info.setOperationType((byte)1);
            ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic(destInfo.getDestination());
            this.fireAdvisory(context, topic, info);
            try {
                this.next.removeDestination(context, AdvisorySupport.getConsumerAdvisoryTopic(info.getDestination()), -1L);
            }
            catch (Exception expectedIfDestinationDidNotExistYet) {
                // empty catch block
            }
            try {
                this.next.removeDestination(context, AdvisorySupport.getProducerAdvisoryTopic(info.getDestination()), -1L);
            }
            catch (Exception expectedIfDestinationDidNotExistYet) {
                // empty catch block
            }
        }
    }

    @Override
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        super.removeConnection(context, info, error);
        ActiveMQTopic topic = AdvisorySupport.getConnectionAdvisoryTopic();
        this.fireAdvisory(context, topic, info.createRemoveCommand());
        this.connections.remove(info.getConnectionId());
    }

    @Override
    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        super.removeConsumer(context, info);
        ActiveMQDestination dest = info.getDestination();
        if (!AdvisorySupport.isAdvisoryTopic(dest)) {
            ActiveMQTopic topic = AdvisorySupport.getConsumerAdvisoryTopic(dest);
            this.consumers.remove(info.getConsumerId());
            if (!dest.isTemporary() || this.destinations.containsKey(dest)) {
                this.fireConsumerAdvisory(context, dest, topic, info.createRemoveCommand());
            }
        }
    }

    @Override
    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        super.removeProducer(context, info);
        ActiveMQDestination dest = info.getDestination();
        if (info.getDestination() != null && !AdvisorySupport.isAdvisoryTopic(dest)) {
            ActiveMQTopic topic = AdvisorySupport.getProducerAdvisoryTopic(dest);
            this.producers.remove(info.getProducerId());
            if (!dest.isTemporary() || this.destinations.contains(dest)) {
                this.fireProducerAdvisory(context, dest, topic, info.createRemoveCommand());
            }
        }
    }

    @Override
    public void messageExpired(ConnectionContext context, MessageReference messageReference, Subscription subscription) {
        super.messageExpired(context, messageReference, subscription);
        try {
            if (!messageReference.isAdvisory()) {
                ActiveMQTopic topic = AdvisorySupport.getExpiredMessageTopic(messageReference.getMessage().getDestination());
                Message payload = messageReference.getMessage().copy();
                payload.clearBody();
                ActiveMQMessage advisoryMessage = new ActiveMQMessage();
                advisoryMessage.setStringProperty("orignalMessageId", payload.getMessageId().toString());
                this.fireAdvisory(context, topic, payload, null, advisoryMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("expired", e);
        }
    }

    @Override
    public void messageConsumed(ConnectionContext context, MessageReference messageReference) {
        super.messageConsumed(context, messageReference);
        try {
            if (!messageReference.isAdvisory()) {
                ActiveMQTopic topic = AdvisorySupport.getMessageConsumedAdvisoryTopic(messageReference.getMessage().getDestination());
                Message payload = messageReference.getMessage().copy();
                payload.clearBody();
                this.fireAdvisory(context, topic, payload);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("consumed", e);
        }
    }

    @Override
    public void messageDelivered(ConnectionContext context, MessageReference messageReference) {
        super.messageDelivered(context, messageReference);
        try {
            if (!messageReference.isAdvisory()) {
                ActiveMQTopic topic = AdvisorySupport.getMessageDeliveredAdvisoryTopic(messageReference.getMessage().getDestination());
                Message payload = messageReference.getMessage().copy();
                payload.clearBody();
                this.fireAdvisory(context, topic, payload);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("delivered", e);
        }
    }

    @Override
    public void messageDiscarded(ConnectionContext context, Subscription sub, MessageReference messageReference) {
        super.messageDiscarded(context, sub, messageReference);
        try {
            if (!messageReference.isAdvisory()) {
                ActiveMQTopic topic = AdvisorySupport.getMessageDiscardedAdvisoryTopic(messageReference.getMessage().getDestination());
                Message payload = messageReference.getMessage().copy();
                payload.clearBody();
                ActiveMQMessage advisoryMessage = new ActiveMQMessage();
                if (sub instanceof TopicSubscription) {
                    advisoryMessage.setIntProperty("discardedCount", ((TopicSubscription)sub).discarded());
                }
                advisoryMessage.setStringProperty("consumerId", sub.getConsumerInfo().getConsumerId().toString());
                this.fireAdvisory(context, topic, payload, null, advisoryMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("discarded", e);
        }
    }

    @Override
    public void slowConsumer(ConnectionContext context, Destination destination, Subscription subs) {
        super.slowConsumer(context, destination, subs);
        try {
            ActiveMQTopic topic = AdvisorySupport.getSlowConsumerAdvisoryTopic(destination.getActiveMQDestination());
            ActiveMQMessage advisoryMessage = new ActiveMQMessage();
            advisoryMessage.setStringProperty("consumerId", subs.getConsumerInfo().getConsumerId().toString());
            this.fireAdvisory(context, topic, subs.getConsumerInfo(), null, advisoryMessage);
        }
        catch (Exception e) {
            this.handleFireFailure("slow consumer", e);
        }
    }

    @Override
    public void fastProducer(ConnectionContext context, ProducerInfo producerInfo) {
        super.fastProducer(context, producerInfo);
        try {
            ActiveMQTopic topic = AdvisorySupport.getFastProducerAdvisoryTopic(producerInfo.getDestination());
            ActiveMQMessage advisoryMessage = new ActiveMQMessage();
            advisoryMessage.setStringProperty("producerId", producerInfo.getProducerId().toString());
            this.fireAdvisory(context, topic, producerInfo, null, advisoryMessage);
        }
        catch (Exception e) {
            this.handleFireFailure("fast producer", e);
        }
    }

    @Override
    public void isFull(ConnectionContext context, Destination destination, Usage usage) {
        super.isFull(context, destination, usage);
        if (!AdvisorySupport.isAdvisoryTopic(destination.getActiveMQDestination())) {
            try {
                ActiveMQTopic topic = AdvisorySupport.getFullAdvisoryTopic(destination.getActiveMQDestination());
                ActiveMQMessage advisoryMessage = new ActiveMQMessage();
                advisoryMessage.setStringProperty("usageName", usage.getName());
                this.fireAdvisory(context, topic, null, null, advisoryMessage);
            }
            catch (Exception e) {
                this.handleFireFailure("is full", e);
            }
        }
    }

    @Override
    public void nowMasterBroker() {
        super.nowMasterBroker();
        try {
            ActiveMQTopic topic = AdvisorySupport.getMasterBrokerAdvisoryTopic();
            ActiveMQMessage advisoryMessage = new ActiveMQMessage();
            ConnectionContext context = new ConnectionContext();
            context.setSecurityContext(SecurityContext.BROKER_SECURITY_CONTEXT);
            context.setBroker(this.getBrokerService().getBroker());
            this.fireAdvisory(context, topic, null, null, advisoryMessage);
        }
        catch (Exception e) {
            this.handleFireFailure("now master broker", e);
        }
    }

    @Override
    public void sendToDeadLetterQueue(ConnectionContext context, MessageReference messageReference, Subscription subscription) {
        super.sendToDeadLetterQueue(context, messageReference, subscription);
        try {
            if (!messageReference.isAdvisory()) {
                ActiveMQTopic topic = AdvisorySupport.getMessageDLQdAdvisoryTopic(messageReference.getMessage().getDestination());
                Message payload = messageReference.getMessage().copy();
                payload.clearBody();
                this.fireAdvisory(context, topic, payload);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("add to DLQ", e);
        }
    }

    @Override
    public void networkBridgeStarted(BrokerInfo brokerInfo, boolean createdByDuplex, String remoteIp) {
        try {
            if (brokerInfo != null) {
                ActiveMQMessage advisoryMessage = new ActiveMQMessage();
                advisoryMessage.setBooleanProperty("started", true);
                advisoryMessage.setBooleanProperty("createdByDuplex", createdByDuplex);
                advisoryMessage.setStringProperty("remoteIp", remoteIp);
                ActiveMQTopic topic = AdvisorySupport.getNetworkBridgeAdvisoryTopic();
                ConnectionContext context = new ConnectionContext();
                context.setSecurityContext(SecurityContext.BROKER_SECURITY_CONTEXT);
                context.setBroker(this.getBrokerService().getBroker());
                this.fireAdvisory(context, topic, brokerInfo, null, advisoryMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("network bridge started", e);
        }
    }

    @Override
    public void networkBridgeStopped(BrokerInfo brokerInfo) {
        try {
            if (brokerInfo != null) {
                ActiveMQMessage advisoryMessage = new ActiveMQMessage();
                advisoryMessage.setBooleanProperty("started", false);
                ActiveMQTopic topic = AdvisorySupport.getNetworkBridgeAdvisoryTopic();
                ConnectionContext context = new ConnectionContext();
                context.setSecurityContext(SecurityContext.BROKER_SECURITY_CONTEXT);
                context.setBroker(this.getBrokerService().getBroker());
                this.fireAdvisory(context, topic, brokerInfo, null, advisoryMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("network bridge stopped", e);
        }
    }

    private void handleFireFailure(String message, Throwable cause) {
        LOG.warn("Failed to fire " + message + " advisory, reason: " + cause);
        if (LOG.isDebugEnabled()) {
            LOG.debug(message + " detail", cause);
        }
    }

    protected void fireAdvisory(ConnectionContext context, ActiveMQTopic topic, Command command) throws Exception {
        this.fireAdvisory(context, topic, command, null);
    }

    protected void fireAdvisory(ConnectionContext context, ActiveMQTopic topic, Command command, ConsumerId targetConsumerId) throws Exception {
        ActiveMQMessage advisoryMessage = new ActiveMQMessage();
        this.fireAdvisory(context, topic, command, targetConsumerId, advisoryMessage);
    }

    protected void fireConsumerAdvisory(ConnectionContext context, ActiveMQDestination consumerDestination, ActiveMQTopic topic, Command command) throws Exception {
        this.fireConsumerAdvisory(context, consumerDestination, topic, command, null);
    }

    protected void fireConsumerAdvisory(ConnectionContext context, ActiveMQDestination consumerDestination, ActiveMQTopic topic, Command command, ConsumerId targetConsumerId) throws Exception {
        ActiveMQMessage advisoryMessage = new ActiveMQMessage();
        int count = 0;
        Set<Destination> set = this.getDestinations(consumerDestination);
        if (set != null) {
            for (Destination dest : set) {
                count = (int)((long)count + dest.getDestinationStatistics().getConsumers().getCount());
            }
        }
        advisoryMessage.setIntProperty("consumerCount", count);
        this.fireAdvisory(context, topic, command, targetConsumerId, advisoryMessage);
    }

    protected void fireProducerAdvisory(ConnectionContext context, ActiveMQDestination producerDestination, ActiveMQTopic topic, Command command) throws Exception {
        this.fireProducerAdvisory(context, producerDestination, topic, command, null);
    }

    protected void fireProducerAdvisory(ConnectionContext context, ActiveMQDestination producerDestination, ActiveMQTopic topic, Command command, ConsumerId targetConsumerId) throws Exception {
        Set<Destination> set;
        ActiveMQMessage advisoryMessage = new ActiveMQMessage();
        int count = 0;
        if (producerDestination != null && (set = this.getDestinations(producerDestination)) != null) {
            for (Destination dest : set) {
                count = (int)((long)count + dest.getDestinationStatistics().getProducers().getCount());
            }
        }
        advisoryMessage.setIntProperty("producerCount", count);
        this.fireAdvisory(context, topic, command, targetConsumerId, advisoryMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAdvisory(ConnectionContext context, ActiveMQTopic topic, Command command, ConsumerId targetConsumerId, ActiveMQMessage advisoryMessage) throws Exception {
        if (this.getBrokerService().isStarted()) {
            advisoryMessage.setStringProperty("originBrokerName", this.getBrokerName());
            String id = this.getBrokerId() != null ? this.getBrokerId().getValue() : "NOT_SET";
            advisoryMessage.setStringProperty("originBrokerId", id);
            String url = this.getBrokerService().getVmConnectorURI().toString();
            if (this.getBrokerService().getDefaultSocketURIString() != null) {
                url = this.getBrokerService().getDefaultSocketURIString();
            }
            advisoryMessage.setStringProperty("originBrokerURL", url);
            advisoryMessage.setDataStructure(command);
            advisoryMessage.setPersistent(false);
            advisoryMessage.setType("Advisory");
            advisoryMessage.setMessageId(new MessageId(this.advisoryProducerId, this.messageIdGenerator.getNextSequenceId()));
            advisoryMessage.setTargetConsumerId(targetConsumerId);
            advisoryMessage.setDestination(topic);
            advisoryMessage.setResponseRequired(false);
            advisoryMessage.setProducerId(this.advisoryProducerId);
            boolean originalFlowControl = context.isProducerFlowControl();
            ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
            producerExchange.setConnectionContext(context);
            producerExchange.setMutable(true);
            producerExchange.setProducerState(new ProducerState(new ProducerInfo()));
            try {
                context.setProducerFlowControl(false);
                this.next.send(producerExchange, advisoryMessage);
            }
            finally {
                context.setProducerFlowControl(originalFlowControl);
            }
        }
    }

    public Map<ConnectionId, ConnectionInfo> getAdvisoryConnections() {
        return this.connections;
    }

    public Map<ConsumerId, ConsumerInfo> getAdvisoryConsumers() {
        return this.consumers;
    }

    public Map<ProducerId, ProducerInfo> getAdvisoryProducers() {
        return this.producers;
    }

    public Map<ActiveMQDestination, DestinationInfo> getAdvisoryDestinations() {
        return this.destinations;
    }
}

