/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.component;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.WebFault;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.common.util.URIResolver;
import org.apache.servicemix.wsn.ComponentContextAware;
import org.apache.servicemix.wsn.jbi.JbiWrapperHelper;
import org.oasis_open.docs.wsrf.bf_2.BaseFaultType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSNEndpoint
extends ProviderEndpoint {
    protected String address;
    protected Object pojo;
    protected JAXBContext jaxbContext;
    protected Set<Class> endpointInterfaces = new HashSet<Class>();

    public WSNEndpoint(String address, Object pojo) {
        this.address = address;
        this.pojo = pojo;
        String[] parts = URIResolver.split3((String)address);
        this.service = new QName(parts[0], parts[1]);
        this.endpoint = parts[2];
    }

    public void activate() throws Exception {
        WebService ws = this.getWebServiceAnnotation(this.pojo.getClass());
        if (ws == null) {
            throw new IllegalStateException("Unable to find WebService annotation");
        }
        Class<?> mainInterface = Class.forName(ws.endpointInterface());
        this.endpointInterfaces.add(mainInterface);
        for (Class<?> pojoClass = this.pojo.getClass(); pojoClass != Object.class; pojoClass = pojoClass.getSuperclass()) {
            for (Class<?> cl : pojoClass.getInterfaces()) {
                if (this.getWebServiceAnnotation(cl) == null) continue;
                this.endpointInterfaces.add(cl);
            }
        }
        this.jaxbContext = WSNEndpoint.createJAXBContext(this.endpointInterfaces);
        ws = this.getWebServiceAnnotation(mainInterface);
        if (ws != null) {
            this.interfaceName = new QName(ws.targetNamespace(), ws.name());
        }
        super.activate();
        if (this.pojo instanceof ComponentContextAware) {
            ((ComponentContextAware)this.pojo).setContext(this.getContext());
        }
    }

    public static JAXBContext createJAXBContext(Class interfaceClass) throws JAXBException {
        return WSNEndpoint.createJAXBContext(Collections.singletonList(interfaceClass));
    }

    public static JAXBContext createJAXBContext(Iterable<Class> interfaceClasses) throws JAXBException {
        ArrayList classes = new ArrayList();
        classes.add(JbiFault.class);
        classes.add(XmlException.class);
        for (Class interfaceClass : interfaceClasses) {
            for (Method mth : interfaceClass.getMethods()) {
                WebMethod wm = mth.getAnnotation(WebMethod.class);
                if (wm == null) continue;
                classes.add(mth.getReturnType());
                classes.addAll(Arrays.asList(mth.getParameterTypes()));
            }
        }
        return JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]));
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public void process(MessageExchange exchange) throws Exception {
        Object output;
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        AtomicBoolean isJbiWrapped = new AtomicBoolean(false);
        Source source = exchange.getMessage("in").getContent();
        source = JbiWrapperHelper.unwrap(source, isJbiWrapped);
        Object input = this.jaxbContext.createUnmarshaller().unmarshal(source);
        Method webMethod = null;
        Class inputClass = input.getClass();
        if (input instanceof JAXBElement) {
            inputClass = ((JAXBElement)input).getDeclaredType();
            input = ((JAXBElement)input).getValue();
        }
        for (Class clazz : this.endpointInterfaces) {
            for (Method mth : clazz.getMethods()) {
                Class<?>[] params = mth.getParameterTypes();
                if (params.length != 1 || !params[0].isAssignableFrom(inputClass)) continue;
                if (webMethod == null) {
                    webMethod = mth;
                    continue;
                }
                if (mth.getName().equals(webMethod.getName())) continue;
                throw new IllegalStateException("Multiple methods matching parameters");
            }
        }
        if (webMethod == null) {
            throw new IllegalStateException("Could not determine invoked web method");
        }
        boolean oneWay = webMethod.getAnnotation(Oneway.class) != null;
        try {
            output = webMethod.invoke(this.pojo, input);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                WebFault fa = e.getCause().getClass().getAnnotation(WebFault.class);
                if (!(exchange instanceof InOnly) && fa != null) {
                    BaseFaultType info = (BaseFaultType)e.getCause().getClass().getMethod("getFaultInfo", new Class[0]).invoke((Object)e.getCause(), new Object[0]);
                    if (info.getDescription().size() == 0) {
                        BaseFaultType.Description desc = new BaseFaultType.Description();
                        desc.setValue(e.getCause().getMessage());
                        info.getDescription().add(desc);
                    }
                    if (info.getTimestamp() == null) {
                        info.setTimestamp(DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar()));
                    }
                    Fault fault = exchange.createFault();
                    exchange.setFault(fault);
                    Document doc = JbiWrapperHelper.createDocument();
                    JAXBElement el = new JAXBElement(new QName(fa.targetNamespace(), fa.name()), info.getClass(), null, (Object)info);
                    this.jaxbContext.createMarshaller().marshal((Object)el, (Node)doc);
                    if (isJbiWrapped.get()) {
                        JbiWrapperHelper.wrap(doc);
                    }
                    fault.setContent((Source)new DOMSource(doc));
                    this.send(exchange);
                    return;
                }
                throw (Exception)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        if (oneWay) {
            exchange.setStatus(ExchangeStatus.DONE);
            this.send(exchange);
        } else {
            NormalizedMessage msg = exchange.createMessage();
            exchange.setMessage(msg, "out");
            Document doc = JbiWrapperHelper.createDocument();
            this.jaxbContext.createMarshaller().marshal(output, (Node)doc);
            if (isJbiWrapped.get()) {
                JbiWrapperHelper.wrap(doc);
            }
            msg.setContent((Source)new DOMSource(doc));
            this.send(exchange);
        }
    }

    protected Method getWebServiceMethod(QName interfaceName, QName operation) throws Exception {
        WebService ws = this.getWebServiceAnnotation(this.pojo.getClass());
        if (ws == null) {
            throw new IllegalStateException("Unable to find WebService annotation");
        }
        Class<?> itf = Class.forName(ws.endpointInterface());
        for (Method mth : itf.getMethods()) {
            WebMethod wm = mth.getAnnotation(WebMethod.class);
            if (wm == null) continue;
        }
        return null;
    }

    protected WebService getWebServiceAnnotation(Class clazz) {
        for (Class cl = clazz; cl != null; cl = cl.getSuperclass()) {
            WebService ws = cl.getAnnotation(WebService.class);
            if (ws == null) continue;
            return ws;
        }
        return null;
    }

    @XmlRootElement(name="Exception")
    public static class XmlException {
        private String stackTrace;

        public XmlException() {
        }

        public XmlException(Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.stackTrace = sw.toString();
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        public void setStackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
        }

        @XmlMixed
        public List getContent() {
            return Collections.singletonList(this.stackTrace);
        }
    }

    @XmlRootElement(name="Fault")
    public static class JbiFault {
        private BaseFaultType info;

        public JbiFault() {
        }

        public JbiFault(BaseFaultType info) {
            this.info = info;
        }

        public BaseFaultType getInfo() {
            return this.info;
        }

        public void setInfo(BaseFaultType info) {
            this.info = info;
        }
    }
}

