/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.spring;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.listener.MessageExchangeListener;
import org.apache.servicemix.wsn.client.NotificationBroker;
import org.w3c.dom.Element;

public class PublisherProxyBean
implements MessageExchangeListener {
    private NotificationBroker wsnBroker;
    private String topic;
    @Resource
    private ComponentContext context;
    private SourceTransformer sourceTransformer = new SourceTransformer();

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    @PostConstruct
    public void start() throws JBIException {
        this.wsnBroker = new NotificationBroker(this.context);
    }

    @PreDestroy
    public void stop() throws JBIException {
    }

    public void onMessageExchange(MessageExchange exchange) throws MessagingException {
        if (exchange.getStatus() != ExchangeStatus.ACTIVE) {
            return;
        }
        try {
            Element elem = this.sourceTransformer.toDOMElement(exchange.getMessage("in"));
            this.wsnBroker.notify(this.topic, elem);
            exchange.setStatus(ExchangeStatus.DONE);
        }
        catch (Exception e) {
            exchange.setError(e);
        }
        this.context.getDeliveryChannel().send(exchange);
    }
}

