/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.broker.Connection;
import org.apache.activemq.broker.Connector;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportStatusDetector;
import org.apache.activemq.broker.jmx.ManagedTransportConnector;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.region.ConnectorStatistics;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.security.MessageAuthorizationPolicy;
import org.apache.activemq.thread.DefaultThreadPools;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportAcceptListener;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryAgentFactory;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportConnector
implements Connector,
BrokerServiceAware {
    final Logger LOG = LoggerFactory.getLogger(TransportConnector.class);
    protected CopyOnWriteArrayList<TransportConnection> connections = new CopyOnWriteArrayList();
    protected TransportStatusDetector statusDector;
    private BrokerService brokerService;
    private TransportServer server;
    private URI uri;
    private BrokerInfo brokerInfo = new BrokerInfo();
    private TaskRunnerFactory taskRunnerFactory;
    private MessageAuthorizationPolicy messageAuthorizationPolicy;
    private DiscoveryAgent discoveryAgent;
    private final ConnectorStatistics statistics = new ConnectorStatistics();
    private URI discoveryUri;
    private URI connectUri;
    private String name;
    private boolean disableAsyncDispatch;
    private boolean enableStatusMonitor = false;
    private Broker broker;
    private boolean updateClusterClients = false;
    private boolean rebalanceClusterClients;
    private boolean updateClusterClientsOnRemove = false;
    private String updateClusterFilter;
    Random rnd = new Random(System.currentTimeMillis());

    public TransportConnector() {
    }

    public TransportConnector(TransportServer server) {
        this();
        URI uri;
        this.setServer(server);
        if (server != null && server.getConnectURI() != null && (uri = server.getConnectURI()) != null && uri.getScheme().equals("vm")) {
            this.setEnableStatusMonitor(false);
        }
    }

    public CopyOnWriteArrayList<TransportConnection> getConnections() {
        return this.connections;
    }

    public ManagedTransportConnector asManagedConnector(ManagementContext context, ObjectName connectorName) throws IOException, URISyntaxException {
        ManagedTransportConnector rc = new ManagedTransportConnector(context, connectorName, this.getServer());
        rc.setBrokerInfo(this.getBrokerInfo());
        rc.setConnectUri(this.getConnectUri());
        rc.setDisableAsyncDispatch(this.isDisableAsyncDispatch());
        rc.setDiscoveryAgent(this.getDiscoveryAgent());
        rc.setDiscoveryUri(this.getDiscoveryUri());
        rc.setEnableStatusMonitor(this.isEnableStatusMonitor());
        rc.setMessageAuthorizationPolicy(this.getMessageAuthorizationPolicy());
        rc.setName(this.getName());
        rc.setTaskRunnerFactory(this.getTaskRunnerFactory());
        rc.setUri(this.getUri());
        rc.setBrokerService(this.brokerService);
        rc.setUpdateClusterClients(this.isUpdateClusterClients());
        rc.setRebalanceClusterClients(this.isRebalanceClusterClients());
        rc.setUpdateClusterFilter(this.getUpdateClusterFilter());
        rc.setUpdateClusterClientsOnRemove(this.isUpdateClusterClientsOnRemove());
        return rc;
    }

    @Override
    public BrokerInfo getBrokerInfo() {
        return this.brokerInfo;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
        this.brokerInfo = brokerInfo;
    }

    @Deprecated
    public void setBrokerName(String name) {
        if (this.brokerInfo == null) {
            this.brokerInfo = new BrokerInfo();
        }
        this.brokerInfo.setBrokerName(name);
    }

    public TransportServer getServer() throws IOException, URISyntaxException {
        if (this.server == null) {
            this.setServer(this.createTransportServer());
        }
        return this.server;
    }

    public void setServer(TransportServer server) {
        this.server = server;
    }

    public URI getUri() {
        if (this.uri == null) {
            try {
                this.uri = this.getConnectUri();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public TaskRunnerFactory getTaskRunnerFactory() {
        return this.taskRunnerFactory;
    }

    public void setTaskRunnerFactory(TaskRunnerFactory taskRunnerFactory) {
        this.taskRunnerFactory = taskRunnerFactory;
    }

    @Override
    public ConnectorStatistics getStatistics() {
        return this.statistics;
    }

    public MessageAuthorizationPolicy getMessageAuthorizationPolicy() {
        return this.messageAuthorizationPolicy;
    }

    public void setMessageAuthorizationPolicy(MessageAuthorizationPolicy messageAuthorizationPolicy) {
        this.messageAuthorizationPolicy = messageAuthorizationPolicy;
    }

    @Override
    public void start() throws Exception {
        this.broker = this.brokerService.getBroker();
        this.brokerInfo.setBrokerName(this.broker.getBrokerName());
        this.brokerInfo.setBrokerId(this.broker.getBrokerId());
        this.brokerInfo.setPeerBrokerInfos(this.broker.getPeerBrokerInfos());
        this.brokerInfo.setFaultTolerantConfiguration(this.broker.isFaultTolerantConfiguration());
        this.brokerInfo.setBrokerURL(this.broker.getBrokerService().getDefaultSocketURIString());
        this.getServer().setAcceptListener(new TransportAcceptListener(){

            @Override
            public void onAccept(final Transport transport) {
                try {
                    DefaultThreadPools.getDefaultTaskRunnerFactory().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Connection connection = TransportConnector.this.createConnection(transport);
                                connection.start();
                            }
                            catch (Exception e) {
                                String remoteHost = transport.getRemoteAddress();
                                ServiceSupport.dispose(transport);
                                this.onAcceptError(e, remoteHost);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    String remoteHost = transport.getRemoteAddress();
                    ServiceSupport.dispose(transport);
                    this.onAcceptError(e, remoteHost);
                }
            }

            @Override
            public void onAcceptError(Exception error) {
                this.onAcceptError(error, null);
            }

            private void onAcceptError(Exception error, String remoteHost) {
                TransportConnector.this.LOG.error("Could not accept connection " + (remoteHost == null ? "" : "from " + remoteHost) + ": " + error);
                TransportConnector.this.LOG.debug("Reason: " + error, (Throwable)error);
            }
        });
        this.getServer().setBrokerInfo(this.brokerInfo);
        this.getServer().start();
        DiscoveryAgent da = this.getDiscoveryAgent();
        if (da != null) {
            da.registerService(this.getPublishableConnectString());
            da.start();
        }
        if (this.enableStatusMonitor) {
            this.statusDector = new TransportStatusDetector(this);
            this.statusDector.start();
        }
        this.LOG.info("Connector " + this.getName() + " Started");
    }

    public String getPublishableConnectString() throws Exception {
        return this.getPublishableConnectString(this.getConnectUri());
    }

    public String getPublishableConnectString(URI theConnectURI) throws Exception {
        String publishableConnectString = null;
        if (theConnectURI != null) {
            publishableConnectString = theConnectURI.toString();
            if (theConnectURI.getRawQuery() != null) {
                publishableConnectString = publishableConnectString.substring(0, publishableConnectString.indexOf(theConnectURI.getRawQuery()) - 1);
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Publishing: " + publishableConnectString + " for broker transport URI: " + theConnectURI);
        }
        return publishableConnectString;
    }

    @Override
    public void stop() throws Exception {
        ServiceStopper ss = new ServiceStopper();
        if (this.discoveryAgent != null) {
            ss.stop(this.discoveryAgent);
        }
        if (this.server != null) {
            ss.stop(this.server);
        }
        if (this.statusDector != null) {
            this.statusDector.stop();
        }
        for (TransportConnection c : this.connections) {
            ss.stop(c);
        }
        this.server = null;
        ss.throwFirstException();
        this.LOG.info("Connector " + this.getName() + " Stopped");
    }

    protected Connection createConnection(Transport transport) throws IOException {
        TransportConnection answer = new TransportConnection(this, transport, this.broker, this.disableAsyncDispatch ? null : this.taskRunnerFactory);
        boolean statEnabled = this.getStatistics().isEnabled();
        answer.getStatistics().setEnabled(statEnabled);
        answer.setMessageAuthorizationPolicy(this.messageAuthorizationPolicy);
        return answer;
    }

    protected TransportServer createTransportServer() throws IOException, URISyntaxException {
        if (this.uri == null) {
            throw new IllegalArgumentException("You must specify either a server or uri property");
        }
        if (this.brokerService == null) {
            throw new IllegalArgumentException("You must specify the brokerService property. Maybe this connector should be added to a broker?");
        }
        return TransportFactory.bind(this.brokerService, this.uri);
    }

    public DiscoveryAgent getDiscoveryAgent() throws IOException {
        if (this.discoveryAgent == null) {
            this.discoveryAgent = this.createDiscoveryAgent();
        }
        return this.discoveryAgent;
    }

    protected DiscoveryAgent createDiscoveryAgent() throws IOException {
        if (this.discoveryUri != null) {
            return DiscoveryAgentFactory.createDiscoveryAgent(this.discoveryUri);
        }
        return null;
    }

    public void setDiscoveryAgent(DiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
    }

    public URI getDiscoveryUri() {
        return this.discoveryUri;
    }

    public void setDiscoveryUri(URI discoveryUri) {
        this.discoveryUri = discoveryUri;
    }

    public URI getConnectUri() throws IOException, URISyntaxException {
        if (this.connectUri == null && this.server != null) {
            this.connectUri = this.server.getConnectURI();
        }
        return this.connectUri;
    }

    public void setConnectUri(URI transportUri) {
        this.connectUri = transportUri;
    }

    public void onStarted(TransportConnection connection) {
        this.connections.add(connection);
    }

    public void onStopped(TransportConnection connection) {
        this.connections.remove(connection);
    }

    public String getName() {
        if (this.name == null) {
            this.uri = this.getUri();
            if (this.uri != null) {
                this.name = this.uri.toString();
            }
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        String rc = this.getName();
        if (rc == null) {
            rc = super.toString();
        }
        return rc;
    }

    protected ConnectionControl getConnectionControl() {
        boolean rebalance = this.isRebalanceClusterClients();
        String connectedBrokers = "";
        String separator = "";
        if (this.isUpdateClusterClients()) {
            ArrayList<String> uris = new ArrayList<String>();
            uris.add(this.brokerService.getDefaultSocketURIString());
            for (BrokerInfo info : this.broker.getPeerBrokerInfos()) {
                if (!this.isMatchesClusterFilter(info.getBrokerName()) || info.getBrokerURL() == null) continue;
                uris.add(info.getBrokerURL());
            }
            if (rebalance) {
                Collections.shuffle(uris, this.rnd);
            }
            for (String uri : uris) {
                connectedBrokers = connectedBrokers + separator + uri;
                separator = ",";
            }
        }
        ConnectionControl control = new ConnectionControl();
        control.setConnectedBrokers(connectedBrokers);
        control.setRebalanceConnection(rebalance);
        return control;
    }

    @Override
    public void updateClientClusterInfo() {
        if (this.isRebalanceClusterClients() || this.isUpdateClusterClients()) {
            ConnectionControl control = this.getConnectionControl();
            for (TransportConnection c : this.connections) {
                c.updateClient(control);
                if (!this.isRebalanceClusterClients()) continue;
                control = this.getConnectionControl();
            }
        }
    }

    private boolean isMatchesClusterFilter(String brokerName) {
        boolean result = true;
        String filter = this.getUpdateClusterFilter();
        if (filter != null && (filter = filter.trim()).length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(filter, ",");
            while (result && tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                result = this.isMatchesClusterFilter(brokerName, token);
            }
        }
        return result;
    }

    private boolean isMatchesClusterFilter(String brokerName, String match) {
        boolean result = true;
        if (brokerName != null && match != null && brokerName.length() > 0 && match.length() > 0) {
            result = Pattern.matches(match, brokerName);
        }
        return result;
    }

    public boolean isDisableAsyncDispatch() {
        return this.disableAsyncDispatch;
    }

    public void setDisableAsyncDispatch(boolean disableAsyncDispatch) {
        this.disableAsyncDispatch = disableAsyncDispatch;
    }

    public boolean isEnableStatusMonitor() {
        return this.enableStatusMonitor;
    }

    public void setEnableStatusMonitor(boolean enableStatusMonitor) {
        this.enableStatusMonitor = enableStatusMonitor;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    @Override
    public boolean isUpdateClusterClients() {
        return this.updateClusterClients;
    }

    public void setUpdateClusterClients(boolean updateClusterClients) {
        this.updateClusterClients = updateClusterClients;
    }

    @Override
    public boolean isRebalanceClusterClients() {
        return this.rebalanceClusterClients;
    }

    public void setRebalanceClusterClients(boolean rebalanceClusterClients) {
        this.rebalanceClusterClients = rebalanceClusterClients;
    }

    @Override
    public boolean isUpdateClusterClientsOnRemove() {
        return this.updateClusterClientsOnRemove;
    }

    public void setUpdateClusterClientsOnRemove(boolean updateClusterClientsOnRemove) {
        this.updateClusterClientsOnRemove = updateClusterClientsOnRemove;
    }

    public String getUpdateClusterFilter() {
        return this.updateClusterFilter;
    }

    public void setUpdateClusterFilter(String updateClusterFilter) {
        this.updateClusterFilter = updateClusterFilter;
    }

    @Override
    public int connectionCount() {
        return this.connections.size();
    }
}

