/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.jms;

import java.io.StringReader;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.servicemix.wsn.AbstractSubscription;
import org.apache.servicemix.wsn.jms.InvalidTopicException;
import org.apache.servicemix.wsn.jms.JmsTopicExpressionConverter;
import org.oasis_open.docs.wsn.b_2.InvalidTopicExpressionFaultType;
import org.oasis_open.docs.wsn.b_2.PauseFailedFaultType;
import org.oasis_open.docs.wsn.b_2.ResumeFailedFaultType;
import org.oasis_open.docs.wsn.b_2.Subscribe;
import org.oasis_open.docs.wsn.b_2.SubscribeCreationFailedFaultType;
import org.oasis_open.docs.wsn.b_2.UnableToDestroySubscriptionFaultType;
import org.oasis_open.docs.wsn.b_2.UnacceptableTerminationTimeFaultType;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.PauseFailedFault;
import org.oasis_open.docs.wsn.bw_2.ResumeFailedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public abstract class JmsSubscription
extends AbstractSubscription
implements MessageListener {
    private final Logger logger = LoggerFactory.getLogger(JmsSubscription.class);
    private Connection connection;
    private Session session;
    private JmsTopicExpressionConverter topicConverter = new JmsTopicExpressionConverter();
    private Topic jmsTopic;

    public JmsSubscription(String name) {
        super(name);
    }

    protected void start() throws SubscribeCreationFailedFault {
        try {
            this.session = this.connection.createSession(false, 1);
            MessageConsumer consumer = this.session.createConsumer((Destination)this.jmsTopic);
            consumer.setMessageListener((MessageListener)this);
        }
        catch (JMSException e) {
            SubscribeCreationFailedFaultType fault = new SubscribeCreationFailedFaultType();
            throw new SubscribeCreationFailedFault("Error starting subscription", fault, e);
        }
    }

    protected void validateSubscription(Subscribe subscribeRequest) throws InvalidFilterFault, InvalidMessageContentExpressionFault, InvalidProducerPropertiesExpressionFault, InvalidTopicExpressionFault, SubscribeCreationFailedFault, TopicExpressionDialectUnknownFault, TopicNotSupportedFault, UnacceptableInitialTerminationTimeFault, UnsupportedPolicyRequestFault, UnrecognizedPolicyRequestFault {
        super.validateSubscription(subscribeRequest);
        try {
            this.jmsTopic = this.topicConverter.toActiveMQTopic(this.topic);
        }
        catch (InvalidTopicException e) {
            InvalidTopicExpressionFaultType fault = new InvalidTopicExpressionFaultType();
            throw new InvalidTopicExpressionFault(e.getMessage(), fault);
        }
    }

    protected void pause() throws PauseFailedFault {
        if (this.session == null) {
            PauseFailedFaultType fault = new PauseFailedFaultType();
            throw new PauseFailedFault("Subscription is already paused", fault);
        }
        try {
            this.session.close();
        }
        catch (JMSException e) {
            PauseFailedFaultType fault = new PauseFailedFaultType();
            throw new PauseFailedFault("Error pausing subscription", fault, e);
        }
        finally {
            this.session = null;
        }
    }

    protected void resume() throws ResumeFailedFault {
        if (this.session != null) {
            ResumeFailedFaultType fault = new ResumeFailedFaultType();
            throw new ResumeFailedFault("Subscription is already running", fault);
        }
        try {
            this.session = this.connection.createSession(false, 1);
            MessageConsumer consumer = this.session.createConsumer((Destination)this.jmsTopic);
            consumer.setMessageListener((MessageListener)this);
        }
        catch (JMSException e) {
            ResumeFailedFaultType fault = new ResumeFailedFaultType();
            throw new ResumeFailedFault("Error resuming subscription", fault, e);
        }
    }

    protected void renew(XMLGregorianCalendar terminationTime) throws UnacceptableTerminationTimeFault {
        UnacceptableTerminationTimeFaultType fault = new UnacceptableTerminationTimeFaultType();
        throw new UnacceptableTerminationTimeFault("TerminationTime is not supported", fault);
    }

    protected void unsubscribe() throws UnableToDestroySubscriptionFault {
        super.unsubscribe();
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                UnableToDestroySubscriptionFaultType fault = new UnableToDestroySubscriptionFaultType();
                throw new UnableToDestroySubscriptionFault("Unable to unsubscribe", fault, e);
            }
            finally {
                this.session = null;
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void onMessage(Message jmsMessage) {
        try {
            boolean match;
            TextMessage text = (TextMessage)jmsMessage;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document doc = factory.newDocumentBuilder().parse(new InputSource(new StringReader(text.getText())));
            Element root = doc.getDocumentElement();
            Element holder = (Element)root.getElementsByTagNameNS("http://docs.oasis-open.org/wsn/b-2", "NotificationMessage").item(0);
            Element message = (Element)holder.getElementsByTagNameNS("http://docs.oasis-open.org/wsn/b-2", "Message").item(0);
            Element content = null;
            for (int i = 0; i < message.getChildNodes().getLength(); ++i) {
                if (!(message.getChildNodes().item(i) instanceof Element)) continue;
                content = (Element)message.getChildNodes().item(i);
                break;
            }
            if (match = this.doFilter(content)) {
                if (this.useRaw) {
                    this.doNotify(content);
                } else {
                    this.doNotify(root);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Error notifying consumer", (Throwable)e);
        }
    }

    protected boolean doFilter(Element content) {
        if (this.contentFilter != null) {
            if (!this.contentFilter.getDialect().equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
                throw new IllegalStateException("Unsupported dialect: " + this.contentFilter.getDialect());
            }
            try {
                XPathFactory xpfactory = XPathFactory.newInstance();
                XPath xpath = xpfactory.newXPath();
                XPathExpression exp = xpath.compile(this.contentFilter.getContent().get(0).toString());
                Boolean ret = (Boolean)exp.evaluate(content, XPathConstants.BOOLEAN);
                return ret;
            }
            catch (XPathExpressionException e) {
                this.logger.warn("Could not filter notification", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    protected abstract void doNotify(Element var1);
}

