/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.Message;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;

public class MessageMarshaller
implements Marshaller<Message> {
    private WireFormat wireFormat;

    public MessageMarshaller(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    @Override
    public void writePayload(Message message, DataOutput dataOut) throws IOException {
        ByteSequence packet = this.wireFormat.marshal(message);
        dataOut.writeInt(packet.length);
        dataOut.write(packet.data, packet.offset, packet.length);
    }

    @Override
    public Message readPayload(DataInput dataIn) throws IOException {
        int size = dataIn.readInt();
        byte[] data = new byte[size];
        dataIn.readFully(data);
        return (Message)this.wireFormat.unmarshal(new ByteSequence(data));
    }
}

