/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.jbi;

import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.servicemix.wsn.ComponentContextAware;
import org.apache.servicemix.wsn.client.AbstractWSAClient;
import org.apache.servicemix.wsn.jms.JmsSubscription;
import org.oasis_open.docs.wsn.b_2.Subscribe;
import org.oasis_open.docs.wsn.b_2.SubscribeCreationFailedFaultType;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JbiSubscription
extends JmsSubscription
implements ComponentContextAware {
    private final Logger logger = LoggerFactory.getLogger(JbiSubscription.class);
    private ComponentContext context;
    private ServiceEndpoint endpoint;

    public JbiSubscription(String name) {
        super(name);
    }

    protected void start() throws SubscribeCreationFailedFault {
        super.start();
    }

    protected void validateSubscription(Subscribe subscribeRequest) throws InvalidFilterFault, InvalidMessageContentExpressionFault, InvalidProducerPropertiesExpressionFault, InvalidTopicExpressionFault, SubscribeCreationFailedFault, TopicExpressionDialectUnknownFault, TopicNotSupportedFault, UnacceptableInitialTerminationTimeFault, UnsupportedPolicyRequestFault, UnrecognizedPolicyRequestFault {
        super.validateSubscription(subscribeRequest);
        try {
            this.endpoint = this.resolveConsumer(subscribeRequest);
        }
        catch (Exception e) {
            SubscribeCreationFailedFaultType fault = new SubscribeCreationFailedFaultType();
            throw new SubscribeCreationFailedFault("Unable to resolve consumer reference endpoint", fault, e);
        }
        if (this.endpoint == null) {
            SubscribeCreationFailedFaultType fault = new SubscribeCreationFailedFaultType();
            throw new SubscribeCreationFailedFault("Unable to resolve consumer reference endpoint", fault);
        }
    }

    protected ServiceEndpoint resolveConsumer(Subscribe subscribeRequest) throws Exception {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{Subscribe.class});
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        ctx.createMarshaller().marshal((Object)subscribeRequest, (Node)doc);
        NodeList nl = doc.getDocumentElement().getElementsByTagNameNS("http://docs.oasis-open.org/wsn/b-2", "ConsumerReference");
        if (nl.getLength() != 1) {
            throw new Exception("Subscribe request must have exactly one ConsumerReference node");
        }
        Element el = (Element)nl.item(0);
        DocumentFragment epr = doc.createDocumentFragment();
        epr.appendChild(el);
        ServiceEndpoint ep = this.getContext().resolveEndpointReference(epr);
        if (ep == null) {
            String[] parts = this.split(AbstractWSAClient.getWSAAddress(subscribeRequest.getConsumerReference()));
            ep = this.getContext().getEndpoint(new QName(parts[0], parts[1]), parts[2]);
        }
        return ep;
    }

    protected String[] split(String uri) {
        int sep = uri.indexOf(47) > 0 ? 47 : 58;
        int idx1 = uri.lastIndexOf(sep);
        int idx2 = uri.lastIndexOf(sep, idx1 - 1);
        String epName = uri.substring(idx1 + 1);
        String svcName = uri.substring(idx2 + 1, idx1);
        String nsUri = uri.substring(0, idx2);
        return new String[]{nsUri, svcName, epName};
    }

    protected void doNotify(Element content) {
        try {
            MessageExchangeFactory factory = this.context.getDeliveryChannel().createExchangeFactory(this.endpoint);
            InOnly inonly = factory.createInOnlyExchange();
            NormalizedMessage msg = inonly.createMessage();
            inonly.setInMessage(msg);
            msg.setContent((Source)new DOMSource(content));
            this.context.getDeliveryChannel().send((MessageExchange)inonly);
        }
        catch (JBIException e) {
            this.logger.warn("Could not deliver notification", (Throwable)e);
        }
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public void setContext(ComponentContext context) {
        this.context = context;
    }
}

