/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.component;

import java.util.ArrayList;
import org.apache.servicemix.common.DefaultServiceUnit;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.wsn.component.WSNPublisherEndpoint;
import org.apache.servicemix.wsn.component.WSNPullPointEndpoint;
import org.apache.servicemix.wsn.component.WSNSubscriptionEndpoint;

public class WSNServiceUnit
extends DefaultServiceUnit {
    public void init() throws Exception {
        if (this.status == "Shutdown") {
            ArrayList<Endpoint> activated = new ArrayList<Endpoint>();
            try {
                for (Endpoint endpoint : this.getEndpoints()) {
                    if (!(endpoint instanceof WSNPullPointEndpoint)) continue;
                    endpoint.activate();
                    activated.add(endpoint);
                }
                for (Endpoint endpoint : this.getEndpoints()) {
                    if (!(endpoint instanceof WSNSubscriptionEndpoint)) continue;
                    endpoint.activate();
                    activated.add(endpoint);
                }
                for (Endpoint endpoint : this.getEndpoints()) {
                    if (!(endpoint instanceof WSNPublisherEndpoint)) continue;
                    endpoint.activate();
                    activated.add(endpoint);
                }
                this.status = "Stopped";
            }
            catch (Exception e) {
                for (Endpoint endpoint : activated) {
                    try {
                        endpoint.deactivate();
                    }
                    catch (Exception e2) {}
                }
                throw e;
            }
        }
    }

    public void start() throws Exception {
        if (this.status == "Stopped") {
            ArrayList<Endpoint> started = new ArrayList<Endpoint>();
            try {
                for (Endpoint endpoint : this.getEndpoints()) {
                    if (!(endpoint instanceof WSNPullPointEndpoint)) continue;
                    endpoint.start();
                    started.add(endpoint);
                }
                for (Endpoint endpoint : this.getEndpoints()) {
                    if (!(endpoint instanceof WSNSubscriptionEndpoint)) continue;
                    endpoint.start();
                    started.add(endpoint);
                }
                for (Endpoint endpoint : this.getEndpoints()) {
                    if (!(endpoint instanceof WSNPublisherEndpoint)) continue;
                    endpoint.start();
                    started.add(endpoint);
                }
                this.status = "Started";
            }
            catch (Exception e) {
                for (Endpoint endpoint : started) {
                    try {
                        endpoint.stop();
                    }
                    catch (Exception e2) {}
                }
                throw e;
            }
        }
    }
}

