/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.client;

import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.util.JAXBSource;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.servicemix.common.util.DOMUtil;
import org.apache.servicemix.common.util.URIResolver;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.wsn.jbi.JbiWrapperHelper;
import org.oasis_open.docs.wsn.b_2.Subscribe;
import org.oasis_open.docs.wsn.br_2.RegisterPublisher;
import org.oasis_open.docs.wsrf.rp_2.GetResourcePropertyResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractWSAClient {
    private static JAXBContext jaxbContext;
    private W3CEndpointReference endpoint;
    private ComponentContext context;
    private ServiceEndpoint serviceEndpoint;
    private boolean jbiWrapped;
    private SourceTransformer transformer;

    public AbstractWSAClient() {
    }

    public AbstractWSAClient(ComponentContext context, W3CEndpointReference endpoint) {
        this.context = context;
        this.endpoint = endpoint;
    }

    public boolean isJbiWrapped() {
        return this.jbiWrapped;
    }

    public void setJbiWrapped(boolean jbiWrapped) {
        this.jbiWrapped = jbiWrapped;
    }

    public static W3CEndpointReference createWSA(String address) {
        StringSource src = new StringSource("<EndpointReference xmlns='http://www.w3.org/2005/08/addressing'><Address>" + address + "</Address></EndpointReference>");
        return new W3CEndpointReference((Source)src);
    }

    public static String getWSAAddress(W3CEndpointReference ref) {
        try {
            Element element = JbiWrapperHelper.createDocument().createElement("elem");
            ref.writeTo((Result)new DOMResult(element));
            NodeList nl = element.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "Address");
            if (nl != null && nl.getLength() > 0) {
                Element e = (Element)nl.item(0);
                return DOMUtil.getElementText((Element)e).trim();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return null;
    }

    public static ServiceEndpoint resolveWSA(W3CEndpointReference ref, ComponentContext context) {
        String[] parts = URIResolver.split3((String)AbstractWSAClient.getWSAAddress(ref));
        return context.getEndpoint(new QName(parts[0], parts[1]), parts[2]);
    }

    public W3CEndpointReference getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(W3CEndpointReference endpoint) {
        this.endpoint = endpoint;
    }

    public ServiceEndpoint getServiceEndpoint() {
        if (this.serviceEndpoint == null && this.endpoint != null) {
            this.serviceEndpoint = AbstractWSAClient.resolveWSA(this.endpoint, this.context);
        }
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(ServiceEndpoint serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public void setContext(ComponentContext context) {
        this.context = context;
    }

    protected Object request(Object request) throws JBIException {
        return this.request(null, request);
    }

    protected Object request(QName operation, Object request) throws JBIException {
        try {
            InOut exchange = this.getContext().getDeliveryChannel().createExchangeFactory().createInOutExchange();
            exchange.setEndpoint(this.getServiceEndpoint());
            exchange.setOperation(operation);
            NormalizedMessage in = exchange.createMessage();
            exchange.setInMessage(in);
            if (this.isJbiWrapped()) {
                Document doc = JbiWrapperHelper.createDocument();
                this.getJAXBContext().createMarshaller().marshal(request, (Node)doc);
                JbiWrapperHelper.wrap(doc);
                in.setContent((Source)new DOMSource(doc));
            } else {
                in.setContent((Source)new JAXBSource(this.getJAXBContext(), request));
            }
            this.getContext().getDeliveryChannel().sendSync((MessageExchange)exchange);
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                throw new JBIException((Throwable)exchange.getError());
            }
            if (exchange.getFault() != null) {
                if (this.transformer == null) {
                    this.transformer = new SourceTransformer();
                }
                String fault = this.transformer.contentToString((NormalizedMessage)exchange.getFault());
                exchange.setStatus(ExchangeStatus.DONE);
                this.getContext().getDeliveryChannel().send((MessageExchange)exchange);
                throw new JBIException(fault);
            }
            NormalizedMessage out = exchange.getOutMessage();
            Source source = out.getContent();
            if (this.isJbiWrapped()) {
                source = JbiWrapperHelper.unwrap(source);
            }
            Object result = this.getJAXBContext().createUnmarshaller().unmarshal(source);
            exchange.setStatus(ExchangeStatus.DONE);
            this.getContext().getDeliveryChannel().send((MessageExchange)exchange);
            return result;
        }
        catch (Exception e) {
            throw new JBIException((Throwable)e);
        }
    }

    protected void send(Object request) throws JBIException {
        this.send(null, request);
    }

    protected void send(QName operation, Object request) throws JBIException {
        try {
            InOnly exchange = this.getContext().getDeliveryChannel().createExchangeFactory().createInOnlyExchange();
            exchange.setEndpoint(this.getServiceEndpoint());
            exchange.setOperation(operation);
            NormalizedMessage in = exchange.createMessage();
            exchange.setInMessage(in);
            in.setContent((Source)new JAXBSource(this.getJAXBContext(), request));
            this.getContext().getDeliveryChannel().sendSync((MessageExchange)exchange);
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                throw new JBIException((Throwable)exchange.getError());
            }
        }
        catch (JAXBException e) {
            throw new JBIException((Throwable)e);
        }
    }

    private synchronized JAXBContext getJAXBContext() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Subscribe.class, RegisterPublisher.class, GetResourcePropertyResponse.class});
        }
        return jaxbContext;
    }
}

