/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.client;

import java.util.List;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.servicemix.wsn.AbstractSubscription;
import org.apache.servicemix.wsn.client.AbstractWSAClient;
import org.apache.servicemix.wsn.client.Publisher;
import org.apache.servicemix.wsn.client.Subscription;
import org.oasis_open.docs.wsn.b_2.FilterType;
import org.oasis_open.docs.wsn.b_2.GetCurrentMessage;
import org.oasis_open.docs.wsn.b_2.GetCurrentMessageResponse;
import org.oasis_open.docs.wsn.b_2.NotificationMessageHolderType;
import org.oasis_open.docs.wsn.b_2.Notify;
import org.oasis_open.docs.wsn.b_2.QueryExpressionType;
import org.oasis_open.docs.wsn.b_2.Subscribe;
import org.oasis_open.docs.wsn.b_2.SubscribeResponse;
import org.oasis_open.docs.wsn.b_2.TopicExpressionType;
import org.oasis_open.docs.wsn.b_2.UseRaw;
import org.oasis_open.docs.wsn.br_2.RegisterPublisher;
import org.oasis_open.docs.wsn.br_2.RegisterPublisherResponse;
import org.oasis_open.docs.wsrf.rp_2.GetResourcePropertyResponse;
import org.oasis_open.docs.wsrf.rp_2.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationBroker
extends AbstractWSAClient {
    public static final String WSN_URI = "http://servicemix.org/wsnotification";
    public static final String WSN_SERVICE = "NotificationBroker";
    public static final QName NOTIFICATION_BROKER = new QName("http://servicemix.org/wsnotification", "NotificationBroker");

    public NotificationBroker(ComponentContext context) {
        this(context, "Broker");
    }

    public NotificationBroker(ComponentContext context, String brokerName) {
        this(context, NotificationBroker.createWSA("http://servicemix.org/wsnotification/NotificationBroker/" + brokerName));
    }

    public NotificationBroker(ComponentContext context, W3CEndpointReference endpoint) {
        super(context, endpoint);
    }

    public void notify(String topic, Object msg) throws JBIException {
        Notify notify = new Notify();
        NotificationMessageHolderType holder = new NotificationMessageHolderType();
        if (topic != null) {
            TopicExpressionType topicExp = new TopicExpressionType();
            topicExp.getContent().add(topic);
            holder.setTopic(topicExp);
        }
        holder.setMessage(new NotificationMessageHolderType.Message());
        holder.getMessage().setAny(msg);
        notify.getNotificationMessage().add(holder);
        this.send(notify);
    }

    public Subscription subscribe(W3CEndpointReference consumer, String topic) throws JBIException {
        return this.subscribe(consumer, topic, null, false);
    }

    public Subscription subscribe(W3CEndpointReference consumer, String topic, String xpath) throws JBIException {
        return this.subscribe(consumer, topic, xpath, false);
    }

    public Subscription subscribe(W3CEndpointReference consumer, String topic, String xpath, boolean raw) throws JBIException {
        Subscribe subscribeRequest = new Subscribe();
        subscribeRequest.setConsumerReference(consumer);
        subscribeRequest.setFilter(new FilterType());
        if (topic != null) {
            TopicExpressionType topicExp = new TopicExpressionType();
            topicExp.getContent().add(topic);
            subscribeRequest.getFilter().getAny().add(new JAXBElement(AbstractSubscription.QNAME_TOPIC_EXPRESSION, TopicExpressionType.class, (Object)topicExp));
        }
        if (xpath != null) {
            QueryExpressionType xpathExp = new QueryExpressionType();
            xpathExp.setDialect("http://www.w3.org/TR/1999/REC-xpath-19991116");
            xpathExp.getContent().add(xpath);
            subscribeRequest.getFilter().getAny().add(new JAXBElement(AbstractSubscription.QNAME_MESSAGE_CONTENT, QueryExpressionType.class, (Object)xpathExp));
        }
        if (raw) {
            subscribeRequest.setSubscriptionPolicy(new Subscribe.SubscriptionPolicy());
            subscribeRequest.getSubscriptionPolicy().getAny().add(new UseRaw());
        }
        SubscribeResponse response = (SubscribeResponse)this.request(subscribeRequest);
        return new Subscription(this.getContext(), response.getSubscriptionReference());
    }

    public List<Object> getCurrentMessage(String topic) throws JBIException {
        GetCurrentMessage getCurrentMessageRequest = new GetCurrentMessage();
        if (topic != null) {
            TopicExpressionType topicExp = new TopicExpressionType();
            topicExp.getContent().add(topic);
            getCurrentMessageRequest.setTopic(topicExp);
        }
        GetCurrentMessageResponse response = (GetCurrentMessageResponse)this.request(getCurrentMessageRequest);
        return response.getAny();
    }

    public Publisher registerPublisher(W3CEndpointReference publisherReference, String topic, boolean demand) throws JBIException {
        RegisterPublisher registerPublisherRequest = new RegisterPublisher();
        registerPublisherRequest.setPublisherReference(publisherReference);
        if (topic != null) {
            TopicExpressionType topicExp = new TopicExpressionType();
            topicExp.getContent().add(topic);
            registerPublisherRequest.getTopic().add(topicExp);
        }
        registerPublisherRequest.setDemand(demand);
        RegisterPublisherResponse response = (RegisterPublisherResponse)this.request(registerPublisherRequest);
        return new Publisher(this.getContext(), response.getPublisherRegistrationReference());
    }

    public List<Object> getResourceProperty(QName property) throws JBIException {
        GetResourcePropertyResponse response = (GetResourcePropertyResponse)this.request(new ObjectFactory().createGetResourceProperty(property));
        return response.getAny();
    }
}

