/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.kahadb.journal.Location;
import org.apache.kahadb.util.VariableMarshaller;

class JobLocation {
    private String jobId;
    private int repeat;
    private long startTime;
    private long delay;
    private long nextTime;
    private long period;
    private String cronEntry;
    private final Location location;

    public JobLocation(Location location) {
        this.location = location;
    }

    public JobLocation() {
        this(new Location());
    }

    public void readExternal(DataInput in) throws IOException {
        this.jobId = in.readUTF();
        this.repeat = in.readInt();
        this.startTime = in.readLong();
        this.delay = in.readLong();
        this.nextTime = in.readLong();
        this.period = in.readLong();
        this.cronEntry = in.readUTF();
        this.location.readExternal(in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.jobId);
        out.writeInt(this.repeat);
        out.writeLong(this.startTime);
        out.writeLong(this.delay);
        out.writeLong(this.nextTime);
        out.writeLong(this.period);
        if (this.cronEntry == null) {
            this.cronEntry = "";
        }
        out.writeUTF(this.cronEntry);
        this.location.writeExternal(out);
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public void setRepeat(int repeat) {
        this.repeat = repeat;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long start) {
        this.startTime = start;
    }

    public synchronized long getNextTime() {
        return this.nextTime;
    }

    public synchronized void setNextTime(long nextTime) {
        this.nextTime = nextTime;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public synchronized String getCronEntry() {
        return this.cronEntry;
    }

    public synchronized void setCronEntry(String cronEntry) {
        this.cronEntry = cronEntry;
    }

    public boolean isCron() {
        return this.getCronEntry() != null && this.getCronEntry().length() > 0;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        return "Job [id=" + this.jobId + ", startTime=" + new Date(this.startTime) + ", delay=" + this.delay + ", period=" + this.period + ", repeat=" + this.repeat + ", nextTime=" + new Date(this.nextTime) + "]";
    }

    static class JobLocationMarshaller
    extends VariableMarshaller<List<JobLocation>> {
        static final JobLocationMarshaller INSTANCE = new JobLocationMarshaller();

        JobLocationMarshaller() {
        }

        public List<JobLocation> readPayload(DataInput dataIn) throws IOException {
            ArrayList<JobLocation> result = new ArrayList<JobLocation>();
            int size = dataIn.readInt();
            for (int i = 0; i < size; ++i) {
                JobLocation jobLocation = new JobLocation();
                jobLocation.readExternal(dataIn);
                result.add(jobLocation);
            }
            return result;
        }

        public void writePayload(List<JobLocation> value, DataOutput dataOut) throws IOException {
            dataOut.writeInt(value.size());
            for (JobLocation jobLocation : value) {
                jobLocation.writeExternal(dataOut);
            }
        }
    }
}

