/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.kaha.RuntimeStoreException;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.ProxyMessageStore;
import org.apache.activemq.store.ProxyTopicMessageStore;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionRecoveryListener;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.kahadaptor.KahaMessageStore;
import org.apache.activemq.store.kahadaptor.KahaPersistenceAdapter;
import org.apache.activemq.store.kahadaptor.KahaTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KahaTransactionStore
implements TransactionStore,
BrokerServiceAware {
    private static final Logger LOG = LoggerFactory.getLogger(KahaTransactionStore.class);
    private final Map transactions = new ConcurrentHashMap();
    private final Map prepared;
    private final KahaPersistenceAdapter adaptor;
    private BrokerService brokerService;

    KahaTransactionStore(KahaPersistenceAdapter adaptor, Map preparedMap) {
        this.adaptor = adaptor;
        this.prepared = preparedMap;
    }

    public MessageStore proxy(MessageStore messageStore) {
        return new ProxyMessageStore(messageStore){

            @Override
            public void addMessage(ConnectionContext context, Message send) throws IOException {
                KahaTransactionStore.this.addMessage(this.getDelegate(), send);
            }

            @Override
            public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
                KahaTransactionStore.this.removeMessage(this.getDelegate(), ack);
            }
        };
    }

    public TopicMessageStore proxy(TopicMessageStore messageStore) {
        return new ProxyTopicMessageStore(messageStore){

            @Override
            public void addMessage(ConnectionContext context, Message send) throws IOException {
                KahaTransactionStore.this.addMessage(this.getDelegate(), send);
            }

            @Override
            public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
                KahaTransactionStore.this.removeMessage(this.getDelegate(), ack);
            }

            @Override
            public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId, MessageAck ack) throws IOException {
                KahaTransactionStore.this.acknowledge((TopicMessageStore)this.getDelegate(), clientId, subscriptionName, messageId, ack);
            }
        };
    }

    @Override
    public void prepare(TransactionId txid) {
        KahaTransaction tx = this.getTx(txid);
        if (tx != null) {
            tx.prepare();
            this.prepared.put(txid, tx);
        }
    }

    @Override
    public void commit(TransactionId txid, boolean wasPrepared, Runnable before, Runnable after) throws IOException {
        KahaTransaction tx;
        if (before != null) {
            before.run();
        }
        if ((tx = this.getTx(txid)) != null) {
            tx.commit(this);
            this.removeTx(txid);
        }
        if (after != null) {
            after.run();
        }
    }

    @Override
    public void rollback(TransactionId txid) {
        KahaTransaction tx = this.getTx(txid);
        if (tx != null) {
            tx.rollback();
            this.removeTx(txid);
        }
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public synchronized void recover(TransactionRecoveryListener listener) throws IOException {
        for (Map.Entry entry : this.prepared.entrySet()) {
            XATransactionId xid = (XATransactionId)entry.getKey();
            KahaTransaction kt = (KahaTransaction)entry.getValue();
            listener.recover(xid, kt.getMessages(), kt.getAcks());
        }
    }

    void addMessage(MessageStore destination, Message message) throws IOException {
        try {
            if (message.isInTransaction()) {
                KahaTransaction tx = this.getOrCreateTx(message.getTransactionId());
                tx.add((KahaMessageStore)destination, message);
            } else {
                destination.addMessage(null, message);
            }
        }
        catch (RuntimeStoreException rse) {
            if (rse.getCause() instanceof IOException) {
                this.brokerService.handleIOException((IOException)rse.getCause());
            }
            throw rse;
        }
    }

    final void removeMessage(MessageStore destination, MessageAck ack) throws IOException {
        try {
            if (ack.isInTransaction()) {
                KahaTransaction tx = this.getOrCreateTx(ack.getTransactionId());
                tx.add((KahaMessageStore)destination, ack);
            } else {
                destination.removeMessage(null, ack);
            }
        }
        catch (RuntimeStoreException rse) {
            if (rse.getCause() instanceof IOException) {
                this.brokerService.handleIOException((IOException)rse.getCause());
            }
            throw rse;
        }
    }

    final void acknowledge(TopicMessageStore destination, String clientId, String subscriptionName, MessageId messageId, MessageAck ack) throws IOException {
        try {
            if (ack.isInTransaction()) {
                KahaTransaction tx = this.getOrCreateTx(ack.getTransactionId());
                tx.add((KahaMessageStore)((Object)destination), clientId, subscriptionName, messageId, ack);
            } else {
                destination.acknowledge(null, clientId, subscriptionName, messageId, ack);
            }
        }
        catch (RuntimeStoreException rse) {
            if (rse.getCause() instanceof IOException) {
                this.brokerService.handleIOException((IOException)rse.getCause());
            }
            throw rse;
        }
    }

    protected synchronized KahaTransaction getTx(TransactionId key) {
        KahaTransaction result = (KahaTransaction)this.transactions.get(key);
        if (result == null) {
            result = (KahaTransaction)this.prepared.get(key);
        }
        return result;
    }

    protected synchronized KahaTransaction getOrCreateTx(TransactionId key) {
        KahaTransaction result = (KahaTransaction)this.transactions.get(key);
        if (result == null) {
            result = new KahaTransaction();
            this.transactions.put(key, result);
        }
        return result;
    }

    protected synchronized void removeTx(TransactionId key) {
        this.transactions.remove(key);
        this.prepared.remove(key);
    }

    public void delete() {
        this.transactions.clear();
        this.prepared.clear();
    }

    protected MessageStore getStoreById(Object id) {
        return this.adaptor.retrieveMessageStore(id);
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }
}

