/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import com.thoughtworks.xstream.io.xml.xppdom.XppFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.broker.BrokerContextAware;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.transport.stomp.FrameTranslator;
import org.apache.activemq.transport.stomp.LegacyFrameTranslator;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.Stomp;
import org.apache.activemq.transport.stomp.StompFrame;
import org.codehaus.jettison.mapped.Configuration;

public class JmsFrameTranslator
extends LegacyFrameTranslator
implements BrokerContextAware {
    XStream xStream = null;
    BrokerContext brokerContext;

    @Override
    public ActiveMQMessage convertFrame(ProtocolConverter converter, StompFrame command) throws JMSException, ProtocolException {
        ActiveMQMessage msg;
        Map<String, String> headers = command.getHeaders();
        String transformation = headers.get("transformation");
        if (headers.containsKey("content-length") || transformation.equals(Stomp.Transformations.JMS_BYTE.toString())) {
            msg = super.convertFrame(converter, command);
        } else {
            try {
                String text = new String(command.getContent(), "UTF-8");
                switch (Stomp.Transformations.getValue(transformation)) {
                    case JMS_OBJECT_XML: {
                        XppReader in = new XppReader((Reader)new StringReader(text), XppFactory.createDefaultParser());
                        msg = this.createObjectMessage((HierarchicalStreamReader)in);
                        break;
                    }
                    case JMS_OBJECT_JSON: {
                        HierarchicalStreamReader in = new JettisonMappedXmlDriver().createReader((Reader)new StringReader(text));
                        msg = this.createObjectMessage(in);
                        break;
                    }
                    case JMS_MAP_XML: {
                        XppReader in = new XppReader((Reader)new StringReader(text), XppFactory.createDefaultParser());
                        msg = this.createMapMessage((HierarchicalStreamReader)in);
                        break;
                    }
                    case JMS_MAP_JSON: {
                        HierarchicalStreamReader in = new JettisonMappedXmlDriver().createReader((Reader)new StringReader(text));
                        msg = this.createMapMessage(in);
                        break;
                    }
                    default: {
                        throw new Exception("Unkown transformation: " + transformation);
                    }
                }
            }
            catch (Throwable e) {
                command.getHeaders().put("transformation-error", e.getMessage());
                msg = super.convertFrame(converter, command);
            }
        }
        FrameTranslator.Helper.copyStandardHeadersFromFrameToMessage(converter, command, msg, this);
        return msg;
    }

    @Override
    public StompFrame convertMessage(ProtocolConverter converter, ActiveMQMessage message) throws IOException, JMSException {
        if (message.getDataStructureType() == 26) {
            StompFrame command = new StompFrame();
            command.setAction("MESSAGE");
            HashMap<String, String> headers = new HashMap<String, String>(25);
            command.setHeaders(headers);
            FrameTranslator.Helper.copyStandardHeadersFromMessageToFrame(converter, message, command, this);
            if (((String)headers.get("transformation")).equals(Stomp.Transformations.JMS_XML.toString())) {
                headers.put("transformation", Stomp.Transformations.JMS_OBJECT_XML.toString());
            } else if (((String)headers.get("transformation")).equals(Stomp.Transformations.JMS_JSON.toString())) {
                headers.put("transformation", Stomp.Transformations.JMS_OBJECT_JSON.toString());
            }
            ActiveMQObjectMessage msg = (ActiveMQObjectMessage)message.copy();
            command.setContent(this.marshall(msg.getObject(), (String)headers.get("transformation")).getBytes("UTF-8"));
            return command;
        }
        if (message.getDataStructureType() == 25) {
            StompFrame command = new StompFrame();
            command.setAction("MESSAGE");
            HashMap<String, String> headers = new HashMap<String, String>(25);
            command.setHeaders(headers);
            FrameTranslator.Helper.copyStandardHeadersFromMessageToFrame(converter, message, command, this);
            if (((String)headers.get("transformation")).equals(Stomp.Transformations.JMS_XML.toString())) {
                headers.put("transformation", Stomp.Transformations.JMS_MAP_XML.toString());
            } else if (((String)headers.get("transformation")).equals(Stomp.Transformations.JMS_JSON.toString())) {
                headers.put("transformation", Stomp.Transformations.JMS_MAP_JSON.toString());
            }
            ActiveMQMapMessage msg = (ActiveMQMapMessage)message.copy();
            command.setContent(this.marshall((Serializable)((Object)msg.getContentMap()), (String)headers.get("transformation")).getBytes("UTF-8"));
            return command;
        }
        if (message.getDataStructureType() == 23 && "Advisory".equals(message.getType())) {
            StompFrame command = new StompFrame();
            command.setAction("MESSAGE");
            HashMap<String, String> headers = new HashMap<String, String>(25);
            command.setHeaders(headers);
            FrameTranslator.Helper.copyStandardHeadersFromMessageToFrame(converter, message, command, this);
            if (((String)headers.get("transformation")).equals(Stomp.Transformations.JMS_XML.toString())) {
                headers.put("transformation", Stomp.Transformations.JMS_ADVISORY_XML.toString());
            } else if (((String)headers.get("transformation")).equals(Stomp.Transformations.JMS_JSON.toString())) {
                headers.put("transformation", Stomp.Transformations.JMS_ADVISORY_JSON.toString());
            }
            String body = this.marshallAdvisory(message.getDataStructure(), (String)headers.get("transformation"));
            command.setContent(body.getBytes("UTF-8"));
            return command;
        }
        return super.convertMessage(converter, message);
    }

    protected String marshall(Serializable object, String transformation) throws JMSException {
        StringWriter buffer = new StringWriter();
        Object out = transformation.toLowerCase().endsWith("json") ? new JettisonMappedXmlDriver(new Configuration(), false).createWriter((Writer)buffer) : new PrettyPrintWriter((Writer)buffer);
        this.getXStream().marshal((Object)object, (HierarchicalStreamWriter)out);
        return buffer.toString();
    }

    protected ActiveMQObjectMessage createObjectMessage(HierarchicalStreamReader in) throws JMSException {
        ActiveMQObjectMessage objMsg = new ActiveMQObjectMessage();
        Object obj = this.getXStream().unmarshal(in);
        objMsg.setObject((Serializable)obj);
        return objMsg;
    }

    protected ActiveMQMapMessage createMapMessage(HierarchicalStreamReader in) throws JMSException {
        ActiveMQMapMessage mapMsg = new ActiveMQMapMessage();
        Map map = (Map)this.getXStream().unmarshal(in);
        for (String key : map.keySet()) {
            mapMsg.setObject(key, map.get(key));
        }
        return mapMsg;
    }

    protected String marshallAdvisory(DataStructure ds, String transformation) {
        StringWriter buffer = new StringWriter();
        Object out = transformation.toLowerCase().endsWith("json") ? new JettisonMappedXmlDriver().createWriter((Writer)buffer) : new PrettyPrintWriter((Writer)buffer);
        XStream xstream = this.getXStream();
        xstream.setMode(1001);
        xstream.aliasPackage("", "org.apache.activemq.command");
        xstream.marshal((Object)ds, (HierarchicalStreamWriter)out);
        return buffer.toString();
    }

    public XStream getXStream() {
        if (this.xStream == null) {
            this.xStream = this.createXStream();
        }
        return this.xStream;
    }

    public void setXStream(XStream xStream) {
        this.xStream = xStream;
    }

    protected XStream createXStream() {
        XStream xstream = null;
        if (this.brokerContext != null) {
            Map beans = this.brokerContext.getBeansOfType(XStream.class);
            for (XStream bean : beans.values()) {
                if (bean == null) continue;
                xstream = bean;
                break;
            }
        }
        if (xstream == null) {
            xstream = new XStream();
        }
        return xstream;
    }

    @Override
    public void setBrokerContext(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
    }
}

