/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.IOExceptionHandler;
import org.apache.activemq.util.ServiceStopper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIOExceptionHandler
implements IOExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIOExceptionHandler.class);
    protected BrokerService broker;
    private boolean ignoreAllErrors = false;
    private boolean ignoreNoSpaceErrors = true;
    private boolean ignoreSQLExceptions = true;
    private boolean stopStartConnectors = false;
    private String noSpaceMessage = "space";
    private String sqlExceptionMessage = "";
    private long resumeCheckSleepPeriod = 5000L;
    private AtomicBoolean stopStartInProgress = new AtomicBoolean(false);

    @Override
    public void handle(IOException exception) {
        Throwable cause;
        if (this.ignoreAllErrors) {
            LOG.info("Ignoring IO exception, " + exception, (Throwable)exception);
            return;
        }
        if (this.ignoreNoSpaceErrors) {
            for (cause = exception; cause != null && cause instanceof IOException; cause = cause.getCause()) {
                if (!cause.getMessage().contains(this.noSpaceMessage)) continue;
                LOG.info("Ignoring no space left exception, " + exception, (Throwable)exception);
                return;
            }
        }
        if (this.ignoreSQLExceptions) {
            for (cause = exception; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof SQLException) || !cause.getMessage().contains(this.sqlExceptionMessage)) continue;
                LOG.info("Ignoring SQLException, " + exception, cause);
                return;
            }
        }
        if (this.stopStartConnectors) {
            if (!this.stopStartInProgress.compareAndSet(false, true)) {
                return;
            }
            LOG.info("Initiating stop/restart of broker transport due to IO exception, " + exception, (Throwable)exception);
            new Thread("stop transport connectors on IO exception"){

                @Override
                public void run() {
                    try {
                        ServiceStopper stopper = new ServiceStopper();
                        DefaultIOExceptionHandler.this.broker.stopAllConnectors(stopper);
                    }
                    catch (Exception e) {
                        LOG.warn("Failure occurred while stopping broker connectors", (Throwable)e);
                    }
                }
            }.start();
            new Thread("restart transport connectors post IO exception"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (DefaultIOExceptionHandler.this.hasLockOwnership() && this.isPersistenceAdapterDown()) {
                            LOG.info("waiting for broker persistence adapter checkpoint to succeed before restarting transports");
                            TimeUnit.MILLISECONDS.sleep(DefaultIOExceptionHandler.this.resumeCheckSleepPeriod);
                        }
                        DefaultIOExceptionHandler.this.broker.startAllConnectors();
                    }
                    catch (Exception e) {
                        LOG.warn("Stopping broker due to failure while restarting broker connectors", (Throwable)e);
                        DefaultIOExceptionHandler.this.stopBroker(e);
                    }
                    finally {
                        DefaultIOExceptionHandler.this.stopStartInProgress.compareAndSet(true, false);
                    }
                }

                private boolean isPersistenceAdapterDown() {
                    boolean checkpointSuccess = false;
                    try {
                        DefaultIOExceptionHandler.this.broker.getPersistenceAdapter().checkpoint(true);
                        checkpointSuccess = true;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return !checkpointSuccess;
                }
            }.start();
            return;
        }
        this.stopBroker(exception);
    }

    private void stopBroker(Exception exception) {
        LOG.info("Stopping the broker due to exception, " + exception, (Throwable)exception);
        new Thread("Stopping the broker due to IO exception"){

            @Override
            public void run() {
                try {
                    DefaultIOExceptionHandler.this.broker.stop();
                }
                catch (Exception e) {
                    LOG.warn("Failure occurred while stopping broker", (Throwable)e);
                }
            }
        }.start();
    }

    protected boolean hasLockOwnership() throws IOException {
        return true;
    }

    @Override
    public void setBrokerService(BrokerService broker) {
        this.broker = broker;
    }

    public boolean isIgnoreAllErrors() {
        return this.ignoreAllErrors;
    }

    public void setIgnoreAllErrors(boolean ignoreAllErrors) {
        this.ignoreAllErrors = ignoreAllErrors;
    }

    public boolean isIgnoreNoSpaceErrors() {
        return this.ignoreNoSpaceErrors;
    }

    public void setIgnoreNoSpaceErrors(boolean ignoreNoSpaceErrors) {
        this.ignoreNoSpaceErrors = ignoreNoSpaceErrors;
    }

    public String getNoSpaceMessage() {
        return this.noSpaceMessage;
    }

    public void setNoSpaceMessage(String noSpaceMessage) {
        this.noSpaceMessage = noSpaceMessage;
    }

    public boolean isIgnoreSQLExceptions() {
        return this.ignoreSQLExceptions;
    }

    public void setIgnoreSQLExceptions(boolean ignoreSQLExceptions) {
        this.ignoreSQLExceptions = ignoreSQLExceptions;
    }

    public String getSqlExceptionMessage() {
        return this.sqlExceptionMessage;
    }

    public void setSqlExceptionMessage(String sqlExceptionMessage) {
        this.sqlExceptionMessage = sqlExceptionMessage;
    }

    public boolean isStopStartConnectors() {
        return this.stopStartConnectors;
    }

    public void setStopStartConnectors(boolean stopStartConnectors) {
        this.stopStartConnectors = stopStartConnectors;
    }

    public long getResumeCheckSleepPeriod() {
        return this.resumeCheckSleepPeriod;
    }

    public void setResumeCheckSleepPeriod(long resumeCheckSleepPeriod) {
        this.resumeCheckSleepPeriod = resumeCheckSleepPeriod;
    }
}

