/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.spring;

import javax.xml.bind.JAXBElement;
import org.apache.servicemix.wsn.AbstractSubscription;
import org.apache.servicemix.wsn.client.AbstractWSAClient;
import org.oasis_open.docs.wsn.b_2.FilterType;
import org.oasis_open.docs.wsn.b_2.QueryExpressionType;
import org.oasis_open.docs.wsn.b_2.Subscribe;
import org.oasis_open.docs.wsn.b_2.TopicExpressionType;
import org.oasis_open.docs.wsn.b_2.UseRaw;
import org.springframework.beans.factory.FactoryBean;

public class SubscribeFactoryBean
implements FactoryBean {
    private String consumer;
    private String topic;
    private String xpath;
    private boolean raw;

    public String getConsumer() {
        return this.consumer;
    }

    public void setConsumer(String consumer) {
        this.consumer = consumer;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public void setRaw(boolean raw) {
        this.raw = raw;
    }

    public Object getObject() throws Exception {
        Subscribe subscribe = new Subscribe();
        subscribe.setConsumerReference(AbstractWSAClient.createWSA(this.consumer));
        subscribe.setFilter(new FilterType());
        if (this.topic != null) {
            TopicExpressionType topicExp = new TopicExpressionType();
            topicExp.getContent().add(this.topic);
            subscribe.getFilter().getAny().add(new JAXBElement(AbstractSubscription.QNAME_TOPIC_EXPRESSION, TopicExpressionType.class, (Object)topicExp));
        }
        if (this.xpath != null) {
            QueryExpressionType xpathExp = new QueryExpressionType();
            xpathExp.setDialect("http://www.w3.org/TR/1999/REC-xpath-19991116");
            xpathExp.getContent().add(this.xpath);
            subscribe.getFilter().getAny().add(new JAXBElement(AbstractSubscription.QNAME_MESSAGE_CONTENT, QueryExpressionType.class, (Object)xpathExp));
        }
        if (this.raw) {
            subscribe.setSubscriptionPolicy(new Subscribe.SubscriptionPolicy());
            subscribe.getSubscriptionPolicy().getAny().add(new UseRaw());
        }
        return subscribe;
    }

    public Class getObjectType() {
        return Subscribe.class;
    }

    public boolean isSingleton() {
        return false;
    }
}

