/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.jms;

import java.io.StringWriter;
import java.io.Writer;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.activemq.advisory.ConsumerEvent;
import org.apache.activemq.advisory.ConsumerEventSource;
import org.apache.activemq.advisory.ConsumerListener;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.servicemix.wsn.AbstractPublisher;
import org.apache.servicemix.wsn.jms.InvalidTopicException;
import org.apache.servicemix.wsn.jms.JmsTopicExpressionConverter;
import org.oasis_open.docs.wsn.b_2.InvalidTopicExpressionFaultType;
import org.oasis_open.docs.wsn.b_2.NotificationMessageHolderType;
import org.oasis_open.docs.wsn.b_2.Notify;
import org.oasis_open.docs.wsn.br_2.PublisherRegistrationFailedFaultType;
import org.oasis_open.docs.wsn.br_2.RegisterPublisher;
import org.oasis_open.docs.wsn.br_2.ResourceNotDestroyedFaultType;
import org.oasis_open.docs.wsn.brw_2.PublisherRegistrationFailedFault;
import org.oasis_open.docs.wsn.brw_2.PublisherRegistrationRejectedFault;
import org.oasis_open.docs.wsn.brw_2.ResourceNotDestroyedFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JmsPublisher
extends AbstractPublisher
implements ConsumerListener {
    private final Logger logger = LoggerFactory.getLogger(JmsPublisher.class);
    private Connection connection;
    private JmsTopicExpressionConverter topicConverter = new JmsTopicExpressionConverter();
    private JAXBContext jaxbContext;
    private Topic jmsTopic;
    private ConsumerEventSource advisory;
    private Object subscription;

    public JmsPublisher(String name) {
        super(name);
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Notify.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXB context", e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(NotificationMessageHolderType messageHolder) {
        Session session = null;
        try {
            ActiveMQTopic topic = this.topicConverter.toActiveMQTopic(messageHolder.getTopic());
            session = this.connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)topic);
            Notify notify = new Notify();
            notify.getNotificationMessage().add(messageHolder);
            StringWriter writer = new StringWriter();
            this.jaxbContext.createMarshaller().marshal((Object)notify, (Writer)writer);
            TextMessage message = session.createTextMessage(writer.toString());
            producer.send((Message)message);
        }
        catch (JMSException e) {
            this.logger.warn("Error dispatching message", (Throwable)e);
        }
        catch (JAXBException e) {
            this.logger.warn("Error dispatching message", (Throwable)e);
        }
        catch (InvalidTopicException e) {
            this.logger.warn("Error dispatching message", (Throwable)e);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (JMSException e) {
                    this.logger.debug("Error closing session", (Throwable)e);
                }
            }
        }
    }

    protected void validatePublisher(RegisterPublisher registerPublisherRequest) throws InvalidTopicExpressionFault, PublisherRegistrationFailedFault, PublisherRegistrationRejectedFault, ResourceUnknownFault, TopicNotSupportedFault {
        super.validatePublisher(registerPublisherRequest);
        try {
            this.jmsTopic = this.topicConverter.toActiveMQTopic(this.topic);
        }
        catch (InvalidTopicException e) {
            InvalidTopicExpressionFaultType fault = new InvalidTopicExpressionFaultType();
            throw new InvalidTopicExpressionFault(e.getMessage(), fault);
        }
    }

    protected void start() throws PublisherRegistrationFailedFault {
        if (this.demand) {
            try {
                this.advisory = new ConsumerEventSource(this.connection, (Destination)this.jmsTopic);
                this.advisory.setConsumerListener((ConsumerListener)this);
                this.advisory.start();
            }
            catch (Exception e) {
                PublisherRegistrationFailedFaultType fault = new PublisherRegistrationFailedFaultType();
                throw new PublisherRegistrationFailedFault("Error starting demand-based publisher", fault, e);
            }
        }
    }

    protected void destroy() throws ResourceNotDestroyedFault {
        try {
            if (this.advisory != null) {
                this.advisory.stop();
            }
        }
        catch (Exception e) {
            ResourceNotDestroyedFaultType fault = new ResourceNotDestroyedFaultType();
            throw new ResourceNotDestroyedFault("Error destroying publisher", fault, e);
        }
        finally {
            super.destroy();
        }
    }

    public void onConsumerEvent(ConsumerEvent event) {
        if (event.getConsumerCount() > 0) {
            if (this.subscription == null) {
                this.subscription = this.startSubscription();
            }
        } else if (this.subscription != null) {
            Object sub = this.subscription;
            this.subscription = null;
            this.destroySubscription(sub);
        }
    }

    protected abstract void destroySubscription(Object var1);

    protected abstract Object startSubscription();
}

