/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.lang.reflect.Method;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.servicemix.common.BaseComponent;
import org.apache.servicemix.common.BasicWorkManager;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.ExchangeProcessor;

public class AsyncBaseLifeCycle
implements ComponentLifeCycle {
    protected final transient Log logger;
    protected BaseComponent component;
    protected ComponentContext context;
    protected ObjectName mbeanName;
    protected WorkManager workManager;
    protected AtomicBoolean running;
    protected DeliveryChannel channel;
    protected Thread poller;
    protected AtomicBoolean polling;
    protected TransactionManager transactionManager;
    protected boolean workManagerCreated;
    protected Map processors = new ConcurrentHashMap();

    public AsyncBaseLifeCycle(BaseComponent component) {
        this.component = component;
        this.logger = component.logger;
        this.running = new AtomicBoolean(false);
        this.polling = new AtomicBoolean(false);
        this.processors = new ConcurrentHashMap();
    }

    public ObjectName getExtensionMBeanName() {
        return this.mbeanName;
    }

    protected Object getExtensionMBean() throws Exception {
        return null;
    }

    protected ObjectName createExtensionMBeanName() throws Exception {
        return this.context.getMBeanNames().createCustomComponentMBeanName("Configuration");
    }

    protected QName getEPRServiceName() {
        return null;
    }

    public void init(ComponentContext context) throws JBIException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Initializing component");
            }
            this.context = context;
            this.channel = context.getDeliveryChannel();
            this.transactionManager = (TransactionManager)context.getTransactionManager();
            this.doInit();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Component initialized");
            }
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling init", (Throwable)e);
        }
    }

    protected void doInit() throws Exception {
        MBeanServer server;
        Object mbean = this.getExtensionMBean();
        if (mbean != null && (server = this.context.getMBeanServer()) != null) {
            this.mbeanName = this.createExtensionMBeanName();
            if (server.isRegistered(this.mbeanName)) {
                server.unregisterMBean(this.mbeanName);
            }
            server.registerMBean(mbean, this.mbeanName);
        }
        if (this.workManager == null) {
            this.workManagerCreated = true;
            this.workManager = this.createWorkManager();
        }
    }

    public void shutDown() throws JBIException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Shutting down component");
            }
            this.doShutDown();
            this.context = null;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Component shut down");
            }
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling shutdown", (Throwable)e);
        }
    }

    protected void doShutDown() throws Exception {
        if (this.mbeanName != null) {
            MBeanServer server = this.context.getMBeanServer();
            if (server == null) {
                throw new JBIException("null mBeanServer");
            }
            if (server.isRegistered(this.mbeanName)) {
                server.unregisterMBean(this.mbeanName);
            }
        }
        if (this.workManagerCreated) {
            if (this.workManager instanceof BasicWorkManager) {
                ((BasicWorkManager)this.workManager).shutDown();
            }
            this.workManager = null;
        }
    }

    public void start() throws JBIException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Starting component");
            }
            if (this.running.compareAndSet(false, true)) {
                this.doStart();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Component started");
            }
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling start", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        AtomicBoolean atomicBoolean = this.polling;
        synchronized (atomicBoolean) {
            this.workManager.startWork(new Work(){

                public void release() {
                }

                public void run() {
                    AsyncBaseLifeCycle.this.poller = Thread.currentThread();
                    AsyncBaseLifeCycle.this.pollDeliveryChannel();
                }
            });
            this.polling.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pollDeliveryChannel() {
        AtomicBoolean atomicBoolean = this.polling;
        synchronized (atomicBoolean) {
            this.polling.set(true);
            this.polling.notify();
        }
        while (this.running.get()) {
            try {
                final MessageExchange exchange = this.channel.accept(1000L);
                if (exchange == null) continue;
                final Transaction tx = (Transaction)exchange.getProperty("javax.jbi.transaction.jta");
                if (tx != null) {
                    if (this.transactionManager == null) {
                        throw new IllegalStateException("Exchange is enlisted in a transaction, but no transaction manager is available");
                    }
                    this.transactionManager.suspend();
                }
                this.workManager.scheduleWork(new Work(){

                    public void release() {
                    }

                    public void run() {
                        AsyncBaseLifeCycle.this.processExchangeInTx(exchange, tx);
                    }
                });
            }
            catch (Throwable t) {
                if (!this.running.get()) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)"Polling thread will stop");
                    continue;
                }
                this.logger.error((Object)"Error polling delivery channel", t);
            }
        }
        atomicBoolean = this.polling;
        synchronized (atomicBoolean) {
            this.polling.set(false);
            this.polling.notify();
        }
    }

    public void stop() throws JBIException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Stopping component");
            }
            if (this.running.compareAndSet(true, false)) {
                this.doStop();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Component stopped");
            }
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling stop", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        try {
            AtomicBoolean atomicBoolean = this.polling;
            synchronized (atomicBoolean) {
                if (this.polling.get()) {
                    this.poller.interrupt();
                    this.polling.wait();
                }
            }
        }
        finally {
            this.poller = null;
        }
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    protected WorkManager createWorkManager() {
        return new BasicWorkManager();
    }

    protected WorkManager findWorkManager() {
        try {
            Method getContainerMth = this.context.getClass().getMethod("getContainer", new Class[0]);
            Object container = getContainerMth.invoke((Object)this.context, new Object[0]);
            Method getWorkManagerMth = container.getClass().getMethod("getWorkManager", new Class[0]);
            return (WorkManager)getWorkManagerMth.invoke(container, new Object[0]);
        }
        catch (Throwable t) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"JBI container is not ServiceMix. Will create our own WorkManager", t);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processExchangeInTx(MessageExchange exchange, Transaction tx) {
        block22: {
            try {
                if (tx != null) {
                    this.transactionManager.resume(tx);
                }
                this.processExchange(exchange);
            }
            catch (Exception e) {
                this.logger.error((Object)("Error processing exchange " + exchange), (Throwable)e);
                try {
                    if (tx != null && e instanceof RuntimeException) {
                        this.transactionManager.setRollbackOnly();
                        break block22;
                    }
                    exchange.setError(e);
                    this.channel.send(exchange);
                }
                catch (Exception inner) {
                    this.logger.error((Object)"Error setting exchange status to ERROR", (Throwable)inner);
                }
            }
            finally {
                try {
                    int status;
                    if (tx != null && (status = this.transactionManager.getStatus()) != 6) {
                        this.logger.error((Object)"Transaction is still active after exchange processing. Trying to rollback transaction.");
                        try {
                            this.transactionManager.rollback();
                        }
                        catch (Throwable t) {
                            this.logger.error((Object)"Error trying to rollback transaction.", t);
                        }
                    }
                }
                catch (Throwable t) {
                    this.logger.error((Object)"Error checking transaction status.", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExchange(MessageExchange exchange) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Received exchange: status: " + exchange.getStatus() + ", role: " + exchange.getRole()));
        }
        if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            ExchangeProcessor processor;
            boolean dynamic = false;
            ServiceEndpoint endpoint = exchange.getEndpoint();
            String key = EndpointSupport.getKey(exchange.getEndpoint());
            Endpoint ep = this.component.getRegistry().getEndpoint(key);
            if (ep == null) {
                if (endpoint.getServiceName().equals(this.getEPRServiceName())) {
                    ep = this.getResolvedEPR(exchange.getEndpoint());
                    dynamic = true;
                }
                if (ep == null) {
                    throw new IllegalStateException("Endpoint not found: " + key);
                }
            }
            if ((processor = ep.getProcessor()) == null) {
                throw new IllegalStateException("No processor found for endpoint: " + key);
            }
            try {
                processor.process(exchange);
            }
            finally {
                if (dynamic) {
                    ep.deactivate();
                }
            }
        } else {
            ExchangeProcessor processor = null;
            if (exchange.getProperty("org.apache.servicemix.senderEndpoint") != null) {
                String key = exchange.getProperty("org.apache.servicemix.senderEndpoint").toString();
                Endpoint ep = this.component.getRegistry().getEndpoint(key);
                if (ep != null) {
                    processor = ep.getProcessor();
                }
            } else {
                processor = (ExchangeProcessor)this.processors.remove(exchange.getExchangeId());
            }
            if (processor == null) {
                throw new IllegalStateException("No processor found for: " + exchange.getExchangeId());
            }
            processor.process(exchange);
        }
    }

    public void sendConsumerExchange(MessageExchange exchange, ExchangeProcessor processor) throws MessagingException {
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            this.processors.put(exchange.getExchangeId(), processor);
        }
        this.channel.send(exchange);
    }

    public void sendConsumerExchange(MessageExchange exchange, Endpoint endpoint) throws MessagingException {
        String key = EndpointSupport.getKey(endpoint);
        exchange.setProperty("org.apache.servicemix.senderEndpoint", (Object)key);
        this.channel.send(exchange);
    }

    protected Endpoint getResolvedEPR(ServiceEndpoint ep) throws Exception {
        throw new UnsupportedOperationException("Component does not handle EPR exchanges");
    }
}

