/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.servicemix.common.BaseComponent;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.ServiceUnit;

public class Registry {
    protected BaseComponent component;
    protected Map endpoints;
    protected Map serviceUnits;

    public Registry(BaseComponent component) {
        this.component = component;
        this.endpoints = new HashMap();
        this.serviceUnits = new HashMap();
    }

    public Endpoint getEndpoint(String key) {
        return (Endpoint)this.endpoints.get(key);
    }

    public ServiceUnit getServiceUnit(String name) {
        return (ServiceUnit)this.serviceUnits.get(name);
    }

    public void registerEndpoint(Endpoint ep) {
        String key = EndpointSupport.getKey(ep);
        if (this.endpoints.put(key, ep) != null) {
            throw new IllegalStateException("An endpoint is already registered for key: " + key);
        }
    }

    public void unregisterEndpoint(Endpoint ep) {
        this.endpoints.remove(EndpointSupport.getKey(ep));
    }

    public void registerServiceUnit(ServiceUnit su) {
        this.serviceUnits.put(su.getName(), su);
        Collection endpoints = su.getEndpoints();
        Iterator iter = endpoints.iterator();
        while (iter.hasNext()) {
            Endpoint ep = (Endpoint)iter.next();
            this.registerEndpoint(ep);
        }
    }

    public void unregisterServiceUnit(ServiceUnit su) {
        this.serviceUnits.remove(su.getName());
        Collection endpoints = su.getEndpoints();
        Iterator iter = endpoints.iterator();
        while (iter.hasNext()) {
            Endpoint ep = (Endpoint)iter.next();
            this.unregisterEndpoint(ep);
        }
    }
}

