/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.component;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.activemq.util.IdGenerator;
import org.apache.servicemix.common.AbstractDeployer;
import org.apache.servicemix.common.BaseComponent;
import org.apache.servicemix.common.Deployer;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ExchangeProcessor;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.wsn.EndpointManager;
import org.apache.servicemix.wsn.EndpointRegistrationException;
import org.apache.servicemix.wsn.component.WSNEndpoint;
import org.apache.servicemix.wsn.component.WSNLifeCycle;
import org.apache.servicemix.wsn.jaxws.NotificationBroker;
import org.apache.servicemix.wsn.jbi.JbiNotificationBroker;
import org.apache.servicemix.wsn.jms.JmsCreatePullPoint;
import org.oasis_open.docs.wsn.b_2.CreatePullPoint;
import org.oasis_open.docs.wsn.b_2.CreatePullPointResponse;
import org.oasis_open.docs.wsn.b_2.Subscribe;
import org.oasis_open.docs.wsn.b_2.SubscribeResponse;

public class WSNDeployer
extends AbstractDeployer
implements Deployer {
    protected FilenameFilter filter = new XmlFilter();
    protected JAXBContext context;

    public WSNDeployer(BaseComponent component) {
        super(component);
        try {
            this.context = WSNEndpoint.createJAXBContext(NotificationBroker.class);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not create jaxb context", e);
        }
    }

    public boolean canDeploy(String serviceUnitName, String serviceUnitRootPath) {
        File[] xmls = new File(serviceUnitRootPath).listFiles(this.filter);
        return xmls != null && xmls.length > 0;
    }

    public ServiceUnit deploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        File[] xmls = new File(serviceUnitRootPath).listFiles(this.filter);
        if (xmls == null || xmls.length == 0) {
            throw this.failure("deploy", "No wsdl found", null);
        }
        WSNServiceUnit su = new WSNServiceUnit();
        su.setComponent(this.component);
        su.setName(serviceUnitName);
        su.setRootPath(serviceUnitRootPath);
        for (int i = 0; i < xmls.length; ++i) {
            URL url;
            try {
                url = xmls[i].toURL();
            }
            catch (MalformedURLException e) {
                throw new DeploymentException("Error deploying xml file", (Throwable)e);
            }
            Endpoint ep = this.createEndpoint(url);
            ep.setServiceUnit((ServiceUnit)su);
            su.addEndpoint(ep);
        }
        if (su.getEndpoints().size() == 0) {
            throw this.failure("deploy", "Invalid wsdl: no endpoints found", null);
        }
        return su;
    }

    public Endpoint createEndpoint(URL url) throws DeploymentException {
        Object request = null;
        try {
            request = this.context.createUnmarshaller().unmarshal(url);
        }
        catch (JAXBException e) {
            throw this.failure("deploy", "Invalid xml", (Exception)((Object)e));
        }
        return this.createEndpoint(request);
    }

    public Endpoint createEndpoint(Object request) throws DeploymentException {
        if (request instanceof Subscribe) {
            return new WSNSubscriptionEndpoint((Subscribe)request);
        }
        if (request instanceof CreatePullPoint) {
            return new WSNPullPointEndpoint((CreatePullPoint)request);
        }
        throw this.failure("deploy", "Unsupported request " + request.getClass().getName(), null);
    }

    public static class XmlFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith(".xml");
        }
    }

    public static class WSNServiceUnit
    extends ServiceUnit {
        public void start() throws Exception {
            ArrayList<Endpoint> activated = new ArrayList<Endpoint>();
            try {
                for (Endpoint endpoint : this.getEndpoints()) {
                    if (!(endpoint instanceof WSNPullPointEndpoint)) continue;
                    endpoint.activate();
                    activated.add(endpoint);
                }
                for (Endpoint endpoint : this.getEndpoints()) {
                    if (!(endpoint instanceof WSNSubscriptionEndpoint)) continue;
                    endpoint.activate();
                    activated.add(endpoint);
                }
                this.status = "Started";
            }
            catch (Exception e) {
                for (Endpoint endpoint : activated) {
                    try {
                        endpoint.deactivate();
                    }
                    catch (Exception e2) {}
                }
                throw e;
            }
        }
    }

    public class WSNPullPointEndpoint
    extends Endpoint
    implements EndpointManager {
        private CreatePullPoint request;
        private CreatePullPointResponse response;

        public WSNPullPointEndpoint(CreatePullPoint request) throws DeploymentException {
            this.service = new QName("http://servicemix.org/wsnotification", "Subscription");
            this.endpoint = new IdGenerator().generateSanitizedId();
            this.request = request;
        }

        public MessageExchange.Role getRole() {
            return MessageExchange.Role.PROVIDER;
        }

        public void activate() throws Exception {
            JmsCreatePullPoint createPullPoint = ((WSNLifeCycle)this.serviceUnit.getComponent().getLifeCycle()).getCreatePullPoint();
            this.response = createPullPoint.createPullPoint(this.request);
        }

        public void deactivate() throws Exception {
            JmsCreatePullPoint createPullPoint = ((WSNLifeCycle)this.serviceUnit.getComponent().getLifeCycle()).getCreatePullPoint();
            createPullPoint.destroyPullPoint(this.response.getPullPoint().getAddress().getValue());
        }

        public ExchangeProcessor getProcessor() {
            return null;
        }

        public Object register(String address, Object service) throws EndpointRegistrationException {
            return null;
        }

        public void unregister(Object endpoint) throws EndpointRegistrationException {
        }
    }

    public class WSNSubscriptionEndpoint
    extends Endpoint
    implements EndpointManager {
        private Subscribe request;
        private SubscribeResponse response;

        public WSNSubscriptionEndpoint(Subscribe request) throws DeploymentException {
            this.service = new QName("http://servicemix.org/wsnotification", "Subscription");
            this.endpoint = new IdGenerator().generateSanitizedId();
            this.request = request;
        }

        public MessageExchange.Role getRole() {
            return MessageExchange.Role.CONSUMER;
        }

        public void activate() throws Exception {
            JbiNotificationBroker broker = ((WSNLifeCycle)this.serviceUnit.getComponent().getLifeCycle()).getNotificationBroker();
            this.response = broker.handleSubscribe(this.request, this);
        }

        public void deactivate() throws Exception {
            JbiNotificationBroker broker = ((WSNLifeCycle)this.serviceUnit.getComponent().getLifeCycle()).getNotificationBroker();
            broker.unsubscribe(this.response.getSubscriptionReference().getAddress().getValue());
        }

        public ExchangeProcessor getProcessor() {
            return null;
        }

        public Object register(String address, Object service) throws EndpointRegistrationException {
            return null;
        }

        public void unregister(Object endpoint) throws EndpointRegistrationException {
        }
    }
}

