/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.spring;

import javax.jms.ConnectionFactory;
import org.apache.servicemix.common.BaseComponent;
import org.apache.servicemix.common.BaseLifeCycle;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.wsn.component.WSNDeployer;
import org.apache.servicemix.wsn.component.WSNLifeCycle;
import org.springframework.core.io.Resource;

public class WSNSpringComponent
extends BaseComponent {
    private Resource[] resources;
    private Object[] requests;

    public Resource[] getResources() {
        return this.resources;
    }

    public void setResources(Resource[] endpoints) {
        this.resources = endpoints;
    }

    public Object[] getRequests() {
        return this.requests;
    }

    public void setRequests(Object[] requests) {
        this.requests = requests;
    }

    public ConnectionFactory getConnectionFactory() {
        return ((WSNLifeCycle)this.lifeCycle).getConnectionFactory();
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        ((WSNLifeCycle)this.lifeCycle).setConnectionFactory(connectionFactory);
    }

    protected BaseLifeCycle createLifeCycle() {
        return new LifeCycle();
    }

    public class LifeCycle
    extends WSNLifeCycle {
        protected ServiceUnit su;

        public LifeCycle() {
            super(WSNSpringComponent.this);
        }

        protected void doInit() throws Exception {
            Endpoint ep;
            int i;
            super.doInit();
            this.su = new ServiceUnit();
            this.su.setComponent((BaseComponent)WSNSpringComponent.this);
            WSNDeployer deployer = new WSNDeployer(WSNSpringComponent.this);
            if (WSNSpringComponent.this.resources != null) {
                for (i = 0; i < WSNSpringComponent.this.resources.length; ++i) {
                    ep = deployer.createEndpoint(WSNSpringComponent.this.resources[i].getURL());
                    ep.setServiceUnit(this.su);
                    this.su.addEndpoint(ep);
                }
            }
            if (WSNSpringComponent.this.requests != null) {
                for (i = 0; i < WSNSpringComponent.this.requests.length; ++i) {
                    ep = deployer.createEndpoint(WSNSpringComponent.this.requests[i]);
                    ep.setServiceUnit(this.su);
                    this.su.addEndpoint(ep);
                }
            }
            WSNSpringComponent.this.getRegistry().registerServiceUnit(this.su);
        }

        protected void doStart() throws Exception {
            super.doStart();
            this.su.start();
        }

        protected void doStop() throws Exception {
            this.su.stop();
            super.doStop();
        }

        protected void doShutDown() throws Exception {
            this.su.shutDown();
            super.doShutDown();
        }
    }
}

