/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn;

import org.apache.servicemix.wsn.EndpointManager;
import org.apache.servicemix.wsn.EndpointRegistrationException;
import org.w3._2005._08.addressing.AttributedURIType;
import org.w3._2005._08.addressing.EndpointReferenceType;

public abstract class AbstractEndpoint {
    protected final String name;
    protected String address;
    protected EndpointManager manager;
    protected Object endpoint;

    public AbstractEndpoint(String name) {
        this.name = name;
        this.address = this.createAddress();
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void register() throws EndpointRegistrationException {
        this.endpoint = this.manager.register(this.getAddress(), this);
    }

    public void unregister() throws EndpointRegistrationException {
        if (this.endpoint != null) {
            this.manager.unregister(this.endpoint);
        }
    }

    public EndpointManager getManager() {
        return this.manager;
    }

    public void setManager(EndpointManager manager) {
        this.manager = manager;
    }

    protected abstract String createAddress();

    public static EndpointReferenceType createEndpointReference(String address) {
        EndpointReferenceType epr = new EndpointReferenceType();
        AttributedURIType addressUri = new AttributedURIType();
        addressUri.setValue(address);
        epr.setAddress(addressUri);
        return epr;
    }
}

