/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.jbi;

import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.servicemix.wsn.client.AbstractWSAClient;
import org.apache.servicemix.wsn.client.NotificationBroker;
import org.apache.servicemix.wsn.client.Subscription;
import org.apache.servicemix.wsn.component.WSNLifeCycle;
import org.apache.servicemix.wsn.jaxws.InvalidTopicExpressionFault;
import org.apache.servicemix.wsn.jaxws.PublisherRegistrationFailedFault;
import org.apache.servicemix.wsn.jaxws.PublisherRegistrationRejectedFault;
import org.apache.servicemix.wsn.jaxws.ResourceUnknownFault;
import org.apache.servicemix.wsn.jaxws.TopicNotSupportedFault;
import org.apache.servicemix.wsn.jms.JmsPublisher;
import org.oasis_open.docs.wsn.br_2.PublisherRegistrationFailedFaultType;
import org.oasis_open.docs.wsn.br_2.RegisterPublisher;

public class JbiPublisher
extends JmsPublisher {
    private WSNLifeCycle lifeCycle;
    private ServiceEndpoint endpoint;
    private String notificationBrokerAddress;

    public JbiPublisher(String name) {
        super(name);
    }

    public String getNotificationBrokerAddress() {
        return this.notificationBrokerAddress;
    }

    public void setNotificationBrokerAddress(String notificationBrokerAddress) {
        this.notificationBrokerAddress = notificationBrokerAddress;
    }

    protected Object startSubscription() {
        Subscription subscription = null;
        try {
            NotificationBroker broker = new NotificationBroker(this.getContext());
            broker.setResolver(AbstractWSAClient.resolveWSA(this.publisherReference));
            subscription = broker.subscribe(AbstractWSAClient.createWSA(this.notificationBrokerAddress), "noTopic", null);
        }
        catch (JBIException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return subscription;
    }

    protected void destroySubscription(Object subscription) {
        try {
            ((Subscription)subscription).unsubscribe();
        }
        catch (JBIException e) {
            e.printStackTrace();
        }
    }

    protected void validatePublisher(RegisterPublisher registerPublisherRequest) throws InvalidTopicExpressionFault, PublisherRegistrationFailedFault, PublisherRegistrationRejectedFault, ResourceUnknownFault, TopicNotSupportedFault {
        super.validatePublisher(registerPublisherRequest);
        String[] parts = this.split(this.publisherReference.getAddress().getValue());
        this.endpoint = this.getContext().getEndpoint(new QName(parts[0], parts[1]), parts[2]);
        if (this.endpoint == null) {
            PublisherRegistrationFailedFaultType fault = new PublisherRegistrationFailedFaultType();
            throw new PublisherRegistrationFailedFault("Unable to resolve consumer reference endpoint", fault);
        }
    }

    protected String[] split(String uri) {
        int sep = uri.indexOf(47) > 0 ? 47 : 58;
        int idx1 = uri.lastIndexOf(sep);
        int idx2 = uri.lastIndexOf(sep, idx1 - 1);
        String epName = uri.substring(idx1 + 1);
        String svcName = uri.substring(idx2 + 1, idx1);
        String nsUri = uri.substring(0, idx2);
        return new String[]{nsUri, svcName, epName};
    }

    public ComponentContext getContext() {
        return this.lifeCycle.getContext();
    }

    public WSNLifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public void setLifeCycle(WSNLifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }
}

