/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.client;

import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.servicemix.client.DefaultServiceMixClient;
import org.apache.servicemix.client.ServiceMixClient;
import org.apache.servicemix.client.ServiceMixClientFacade;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.messaging.PojoMarshaler;
import org.apache.servicemix.jbi.resolver.EndpointResolver;
import org.apache.servicemix.jbi.resolver.ServiceAndEndpointNameResolver;
import org.apache.servicemix.jbi.resolver.URIResolver;
import org.apache.servicemix.wsn.client.JAXBMarshaler;
import org.oasis_open.docs.wsn.b_2.Subscribe;
import org.oasis_open.docs.wsn.br_2.RegisterPublisher;
import org.w3._2005._08.addressing.AttributedURIType;
import org.w3._2005._08.addressing.EndpointReferenceType;

public abstract class AbstractWSAClient {
    private EndpointReferenceType endpoint;
    private EndpointResolver resolver;
    private ServiceMixClient client;

    public AbstractWSAClient() {
    }

    public AbstractWSAClient(EndpointReferenceType endpoint, ServiceMixClient client) {
        this.endpoint = endpoint;
        this.resolver = AbstractWSAClient.resolveWSA(endpoint);
        this.client = client;
    }

    public static EndpointReferenceType createWSA(String address) {
        EndpointReferenceType epr = new EndpointReferenceType();
        AttributedURIType attUri = new AttributedURIType();
        attUri.setValue(address);
        epr.setAddress(attUri);
        return epr;
    }

    public static ServiceMixClient createJaxbClient(JBIContainer container) throws JBIException, JAXBException {
        DefaultServiceMixClient client = new DefaultServiceMixClient(container);
        client.setMarshaler((PojoMarshaler)new JAXBMarshaler(JAXBContext.newInstance((Class[])new Class[]{Subscribe.class, RegisterPublisher.class})));
        return client;
    }

    public static ServiceMixClient createJaxbClient(ComponentContext context) throws JAXBException {
        ServiceMixClientFacade client = new ServiceMixClientFacade(context);
        client.setMarshaler((PojoMarshaler)new JAXBMarshaler(JAXBContext.newInstance((Class[])new Class[]{Subscribe.class, RegisterPublisher.class})));
        return client;
    }

    public static EndpointResolver resolveWSA(EndpointReferenceType ref) {
        String[] parts = URIResolver.split3((String)ref.getAddress().getValue());
        return new ServiceAndEndpointNameResolver(new QName(parts[0], parts[1]), parts[2]);
    }

    public EndpointReferenceType getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(EndpointReferenceType endpoint) {
        this.endpoint = endpoint;
    }

    public EndpointResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(EndpointResolver resolver) {
        this.resolver = resolver;
    }

    public ServiceMixClient getClient() {
        return this.client;
    }

    public void setClient(ServiceMixClient client) {
        this.client = client;
    }

    protected Object request(Object request) throws JBIException {
        return this.client.request(this.resolver, null, null, request);
    }

    protected void send(Object request) throws JBIException {
        this.client.sendSync(this.resolver, null, null, request);
    }
}

