
package org.apache.servicemix.wsn.jaxws;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.oasis_open.docs.wsn.b_2.PauseSubscriptionResponse;
import org.oasis_open.docs.wsn.b_2.RenewResponse;
import org.oasis_open.docs.wsn.b_2.ResumeSubscriptionResponse;
import org.oasis_open.docs.wsn.b_2.UnsubscribeResponse;

@WebService(name = "PausableSubscriptionManager", targetNamespace = "http://docs.oasis-open.org/wsn/bw-2")
@SOAPBinding(style = SOAPBinding.Style.DOCUMENT, use = SOAPBinding.Use.LITERAL, parameterStyle = SOAPBinding.ParameterStyle.BARE)
public interface PausableSubscriptionManager {


    @WebMethod(operationName = "ResumeSubscription", action = "")
    @WebResult(name = "ResumeSubscriptionResponse", targetNamespace = "http://docs.oasis-open.org/wsn/b-2")
    public ResumeSubscriptionResponse resumeSubscription(
        @WebParam(name = "ResumeSubscription", targetNamespace = "http://docs.oasis-open.org/wsn/b-2")
        org.oasis_open.docs.wsn.b_2.ResumeSubscription ResumeSubscription)
        throws ResourceUnknownFault, ResumeFailedFault
    ;

    @WebMethod(operationName = "PauseSubscription", action = "")
    @WebResult(name = "PauseSubscriptionResponse", targetNamespace = "http://docs.oasis-open.org/wsn/b-2")
    public PauseSubscriptionResponse pauseSubscription(
        @WebParam(name = "PauseSubscription", targetNamespace = "http://docs.oasis-open.org/wsn/b-2")
        org.oasis_open.docs.wsn.b_2.PauseSubscription PauseSubscription)
        throws PauseFailedFault, ResourceUnknownFault
    ;

    @WebMethod(operationName = "Unsubscribe", action = "")
    @WebResult(name = "UnsubscribeResponse", targetNamespace = "http://docs.oasis-open.org/wsn/b-2")
    public UnsubscribeResponse unsubscribe(
        @WebParam(name = "Unsubscribe", targetNamespace = "http://docs.oasis-open.org/wsn/b-2")
        org.oasis_open.docs.wsn.b_2.Unsubscribe Unsubscribe)
        throws ResourceUnknownFault, UnableToDestroySubscriptionFault
    ;

    @WebMethod(operationName = "Renew", action = "")
    @WebResult(name = "RenewResponse", targetNamespace = "http://docs.oasis-open.org/wsn/b-2")
    public RenewResponse renew(
        @WebParam(name = "Renew", targetNamespace = "http://docs.oasis-open.org/wsn/b-2")
        org.oasis_open.docs.wsn.b_2.Renew Renew)
        throws ResourceUnknownFault, UnacceptableTerminationTimeFault
    ;

}
