
package org.apache.servicemix.wsn.jaxws;

import javax.xml.ws.WebFault;
import org.oasis_open.docs.wsrf.r_2.ResourceUnknownFaultType;

@WebFault(name = "ResourceUnknownFault", targetNamespace = "http://docs.oasis-open.org/wsrf/r-2")
public class ResourceUnknownFault
    extends Exception
{

    private ResourceUnknownFaultType faultInfo;

    public ResourceUnknownFault(String message, ResourceUnknownFaultType faultInfo) {
        super(message);
        this.faultInfo = faultInfo;
    }

    public ResourceUnknownFault(String message, ResourceUnknownFaultType faultInfo, Throwable t) {
        super(message, t);
        this.faultInfo = faultInfo;
    }

    public ResourceUnknownFaultType getFaultInfo() {
        return faultInfo;
    }

}
