/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.spring;

import java.io.StringWriter;
import java.io.Writer;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.bind.JAXBContext;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.util.ComponentSupport;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.wsn.client.AbstractWSAClient;
import org.apache.servicemix.wsn.client.NotificationBroker;
import org.oasis_open.docs.wsn.b_2.Subscribe;
import org.oasis_open.docs.wsn.b_2.SubscribeResponse;
import org.oasis_open.docs.wsn.b_2.Unsubscribe;
import org.oasis_open.docs.wsn.b_2.UnsubscribeResponse;
import org.w3c.dom.Element;

public class PublisherComponent
extends ComponentSupport
implements MessageExchangeListener {
    private static final Log LOG = LogFactory.getLog(PublisherComponent.class);
    private NotificationBroker wsnBroker;
    private String topic;
    private boolean demand;
    private String subscriptionEndpoint = "subscription";
    private Subscribe subscription;

    public boolean getDemand() {
        return this.demand;
    }

    public void setDemand(boolean demand) {
        this.demand = demand;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public Subscribe getSubscription() {
        return this.subscription;
    }

    public void init() throws JBIException {
        super.init();
        this.getContext().activateEndpoint(this.getService(), this.subscriptionEndpoint);
    }

    public void start() throws JBIException {
        new Thread(){

            public void run() {
                try {
                    PublisherComponent.this.wsnBroker = new NotificationBroker(PublisherComponent.this.getContext());
                    String wsaAddress = PublisherComponent.this.getService().getNamespaceURI() + "/" + PublisherComponent.this.getService().getLocalPart() + "/" + PublisherComponent.this.subscriptionEndpoint;
                    PublisherComponent.this.wsnBroker.registerPublisher(AbstractWSAClient.createWSA(wsaAddress), PublisherComponent.this.topic, PublisherComponent.this.demand);
                }
                catch (Exception e) {
                    LOG.error((Object)"Could not create wsn client", (Throwable)e);
                }
            }
        }.start();
    }

    public void shutDown() throws JBIException {
        super.shutDown();
    }

    public void onMessageExchange(MessageExchange exchange) throws MessagingException {
        block11: {
            if (exchange.getStatus() != ExchangeStatus.ACTIVE) {
                return;
            }
            if (exchange.getEndpoint().getEndpointName().equals(this.subscriptionEndpoint)) {
                try {
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Subscribe.class});
                    Source src = exchange.getMessage("in").getContent();
                    Object input = jaxbContext.createUnmarshaller().unmarshal(src);
                    if (input instanceof Subscribe) {
                        this.subscription = (Subscribe)input;
                        SubscribeResponse response = new SubscribeResponse();
                        String wsaAddress = this.getService().getNamespaceURI() + "/" + this.getService().getLocalPart() + "/" + this.subscriptionEndpoint;
                        response.setSubscriptionReference(AbstractWSAClient.createWSA(wsaAddress));
                        StringWriter writer = new StringWriter();
                        jaxbContext.createMarshaller().marshal((Object)response, (Writer)writer);
                        NormalizedMessage out = exchange.createMessage();
                        out.setContent((Source)new StringSource(writer.toString()));
                        exchange.setMessage(out, "out");
                        this.send(exchange);
                        break block11;
                    }
                    if (input instanceof Unsubscribe) {
                        this.subscription = null;
                        UnsubscribeResponse response = new UnsubscribeResponse();
                        StringWriter writer = new StringWriter();
                        jaxbContext.createMarshaller().marshal((Object)response, (Writer)writer);
                        NormalizedMessage out = exchange.createMessage();
                        out.setContent((Source)new StringSource(writer.toString()));
                        exchange.setMessage(out, "out");
                        this.send(exchange);
                        break block11;
                    }
                    throw new Exception("Unkown request");
                }
                catch (Exception e) {
                    this.fail(exchange, e);
                }
            } else {
                try {
                    if (!this.demand || this.subscription != null) {
                        Element elem = new SourceTransformer().toDOMElement(exchange.getMessage("in"));
                        this.wsnBroker.notify(this.topic, elem);
                        this.done(exchange);
                    } else {
                        LOG.info((Object)"Ingore notification as the publisher is no subscribers");
                    }
                }
                catch (Exception e) {
                    this.fail(exchange, e);
                }
            }
        }
    }
}

