/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn;

import java.math.BigInteger;
import java.util.List;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.wsn.AbstractCreatePullPoint;
import org.apache.servicemix.wsn.AbstractEndpoint;
import org.apache.servicemix.wsn.EndpointRegistrationException;
import org.apache.servicemix.wsn.jaxws.NotificationConsumer;
import org.apache.servicemix.wsn.jaxws.PullPoint;
import org.apache.servicemix.wsn.jaxws.ResourceUnknownFault;
import org.apache.servicemix.wsn.jaxws.UnableToCreatePullPointFault;
import org.apache.servicemix.wsn.jaxws.UnableToDestroyPullPointFault;
import org.apache.servicemix.wsn.jaxws.UnableToGetMessagesFault;
import org.oasis_open.docs.wsn.b_2.CreatePullPoint;
import org.oasis_open.docs.wsn.b_2.DestroyPullPoint;
import org.oasis_open.docs.wsn.b_2.DestroyPullPointResponse;
import org.oasis_open.docs.wsn.b_2.GetMessages;
import org.oasis_open.docs.wsn.b_2.GetMessagesResponse;
import org.oasis_open.docs.wsn.b_2.NotificationMessageHolderType;
import org.oasis_open.docs.wsn.b_2.Notify;
import org.oasis_open.docs.wsn.b_2.UnableToDestroyPullPointFaultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(endpointInterface="org.apache.servicemix.wsn.PullPointConsumer")
public abstract class AbstractPullPoint
extends AbstractEndpoint
implements PullPoint,
NotificationConsumer {
    private static Log log = LogFactory.getLog(AbstractPullPoint.class);
    protected AbstractCreatePullPoint createPullPoint;

    public AbstractPullPoint(String name) {
        super(name);
    }

    @Override
    @WebMethod(operationName="Notify")
    @Oneway
    public void notify(@WebParam(name="Notify", targetNamespace="http://docs.oasis-open.org/wsn/b-1", partName="Notify") Notify notify) {
        log.debug((Object)"Notify");
        for (NotificationMessageHolderType messageHolder : notify.getNotificationMessage()) {
            this.store(messageHolder);
        }
    }

    @Override
    @WebMethod(operationName="GetMessages")
    @WebResult(name="GetMessagesResponse", targetNamespace="http://docs.oasis-open.org/wsn/b-1", partName="GetMessagesResponse")
    public GetMessagesResponse getMessages(@WebParam(name="GetMessages", targetNamespace="http://docs.oasis-open.org/wsn/b-1", partName="GetMessagesRequest") GetMessages getMessagesRequest) throws ResourceUnknownFault, UnableToGetMessagesFault {
        log.debug((Object)"GetMessages");
        BigInteger max = getMessagesRequest.getMaximumNumber();
        List<NotificationMessageHolderType> messages = this.getMessages(max != null ? max.intValue() : 0);
        GetMessagesResponse response = new GetMessagesResponse();
        response.getNotificationMessage().addAll(messages);
        return response;
    }

    @Override
    @WebMethod(operationName="DestroyPullPoint")
    @WebResult(name="DestroyPullPointResponse", targetNamespace="http://docs.oasis-open.org/wsn/b-2", partName="DestroyPullPointResponse")
    public DestroyPullPointResponse destroyPullPoint(@WebParam(name="DestroyPullPoint", targetNamespace="http://docs.oasis-open.org/wsn/b-2", partName="DestroyPullPointRequest") DestroyPullPoint destroyPullPointRequest) throws ResourceUnknownFault, UnableToDestroyPullPointFault {
        log.debug((Object)"Destroy");
        this.createPullPoint.destroyPullPoint(this.getAddress());
        return new DestroyPullPointResponse();
    }

    public void create(CreatePullPoint createPullPointRequest) throws UnableToCreatePullPointFault {
    }

    protected abstract void store(NotificationMessageHolderType var1);

    protected abstract List<NotificationMessageHolderType> getMessages(int var1) throws ResourceUnknownFault, UnableToGetMessagesFault;

    protected void destroy() throws UnableToDestroyPullPointFault {
        try {
            this.unregister();
        }
        catch (EndpointRegistrationException e) {
            UnableToDestroyPullPointFaultType fault = new UnableToDestroyPullPointFaultType();
            throw new UnableToDestroyPullPointFault("Error unregistering endpoint", fault, e);
        }
    }

    @Override
    protected String createAddress() {
        return "http://servicemix.org/wsnotification/PullPoint/" + this.getName();
    }

    public AbstractCreatePullPoint getCreatePullPoint() {
        return this.createPullPoint;
    }

    public void setCreatePullPoint(AbstractCreatePullPoint createPullPoint) {
        this.createPullPoint = createPullPoint;
    }
}

