/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import org.apache.servicemix.wsn.AbstractEndpoint;
import org.apache.servicemix.wsn.EndpointRegistrationException;
import org.apache.servicemix.wsn.jaxws.InvalidTopicExpressionFault;
import org.apache.servicemix.wsn.jaxws.PublisherRegistrationFailedFault;
import org.apache.servicemix.wsn.jaxws.PublisherRegistrationManager;
import org.apache.servicemix.wsn.jaxws.PublisherRegistrationRejectedFault;
import org.apache.servicemix.wsn.jaxws.ResourceNotDestroyedFault;
import org.apache.servicemix.wsn.jaxws.ResourceUnknownFault;
import org.apache.servicemix.wsn.jaxws.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.b_2.InvalidTopicExpressionFaultType;
import org.oasis_open.docs.wsn.b_2.NotificationMessageHolderType;
import org.oasis_open.docs.wsn.b_2.TopicExpressionType;
import org.oasis_open.docs.wsn.br_2.DestroyRegistration;
import org.oasis_open.docs.wsn.br_2.DestroyRegistrationResponse;
import org.oasis_open.docs.wsn.br_2.PublisherRegistrationFailedFaultType;
import org.oasis_open.docs.wsn.br_2.RegisterPublisher;
import org.oasis_open.docs.wsn.br_2.ResourceNotDestroyedFaultType;
import org.w3._2005._08.addressing.EndpointReferenceType;

@WebService(endpointInterface="org.apache.servicemix.wsn.jaxws.PublisherRegistrationManager")
public abstract class AbstractPublisher
extends AbstractEndpoint
implements PublisherRegistrationManager {
    protected EndpointReferenceType publisherReference;
    protected boolean demand;
    protected List<TopicExpressionType> topic;

    public AbstractPublisher(String name) {
        super(name);
    }

    @WebMethod(operationName="DestroyRegistration")
    @WebResult(name="DestroyRegistrationResponse", targetNamespace="http://docs.oasis-open.org/wsn/br-2", partName="DestroyRegistrationResponse")
    public DestroyRegistrationResponse destroyRegistration(@WebParam(name="DestroyRegistration", targetNamespace="http://docs.oasis-open.org/wsn/br-2", partName="DestroyRegistrationRequest") DestroyRegistration destroyRegistrationRequest) throws ResourceNotDestroyedFault, ResourceUnknownFault {
        this.destroy();
        return new DestroyRegistrationResponse();
    }

    public abstract void notify(NotificationMessageHolderType var1);

    protected void destroy() throws ResourceNotDestroyedFault {
        try {
            this.unregister();
        }
        catch (EndpointRegistrationException e) {
            ResourceNotDestroyedFaultType fault = new ResourceNotDestroyedFaultType();
            throw new ResourceNotDestroyedFault("Error unregistering endpoint", fault, e);
        }
    }

    protected String createAddress() {
        return "http://servicemix.org/wsnotification/Publisher/" + this.getName();
    }

    public void create(RegisterPublisher registerPublisherRequest) throws InvalidTopicExpressionFault, PublisherRegistrationFailedFault, PublisherRegistrationRejectedFault, ResourceUnknownFault, TopicNotSupportedFault {
        this.validatePublisher(registerPublisherRequest);
        this.start();
    }

    protected void validatePublisher(RegisterPublisher registerPublisherRequest) throws InvalidTopicExpressionFault, PublisherRegistrationFailedFault, PublisherRegistrationRejectedFault, ResourceUnknownFault, TopicNotSupportedFault {
        this.publisherReference = registerPublisherRequest.getPublisherReference();
        this.topic = registerPublisherRequest.getTopic();
        boolean bl = this.demand = registerPublisherRequest.isDemand() != null ? registerPublisherRequest.isDemand() : false;
        if (this.publisherReference == null) {
            PublisherRegistrationFailedFaultType fault = new PublisherRegistrationFailedFaultType();
            throw new PublisherRegistrationFailedFault("Invalid PublisherReference: null", fault);
        }
        if (this.demand && (this.topic == null || this.topic.size() == 0)) {
            InvalidTopicExpressionFaultType fault = new InvalidTopicExpressionFaultType();
            throw new InvalidTopicExpressionFault("Must specify at least one topic for demand-based publishing", fault);
        }
    }

    protected abstract void start() throws PublisherRegistrationFailedFault;
}

