/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import org.apache.activemq.util.IdGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.wsn.AbstractEndpoint;
import org.apache.servicemix.wsn.AbstractPublisher;
import org.apache.servicemix.wsn.AbstractSubscription;
import org.apache.servicemix.wsn.EndpointManager;
import org.apache.servicemix.wsn.EndpointRegistrationException;
import org.apache.servicemix.wsn.jaxws.InvalidFilterFault;
import org.apache.servicemix.wsn.jaxws.InvalidMessageContentExpressionFault;
import org.apache.servicemix.wsn.jaxws.InvalidProducerPropertiesExpressionFault;
import org.apache.servicemix.wsn.jaxws.InvalidTopicExpressionFault;
import org.apache.servicemix.wsn.jaxws.MultipleTopicsSpecifiedFault;
import org.apache.servicemix.wsn.jaxws.NoCurrentMessageOnTopicFault;
import org.apache.servicemix.wsn.jaxws.NotificationBroker;
import org.apache.servicemix.wsn.jaxws.PublisherRegistrationFailedFault;
import org.apache.servicemix.wsn.jaxws.PublisherRegistrationRejectedFault;
import org.apache.servicemix.wsn.jaxws.ResourceNotDestroyedFault;
import org.apache.servicemix.wsn.jaxws.ResourceUnknownFault;
import org.apache.servicemix.wsn.jaxws.SubscribeCreationFailedFault;
import org.apache.servicemix.wsn.jaxws.TopicExpressionDialectUnknownFault;
import org.apache.servicemix.wsn.jaxws.TopicNotSupportedFault;
import org.apache.servicemix.wsn.jaxws.UnableToDestroySubscriptionFault;
import org.apache.servicemix.wsn.jaxws.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.b_2.GetCurrentMessage;
import org.oasis_open.docs.wsn.b_2.GetCurrentMessageResponse;
import org.oasis_open.docs.wsn.b_2.NoCurrentMessageOnTopicFaultType;
import org.oasis_open.docs.wsn.b_2.NotificationMessageHolderType;
import org.oasis_open.docs.wsn.b_2.Notify;
import org.oasis_open.docs.wsn.b_2.Subscribe;
import org.oasis_open.docs.wsn.b_2.SubscribeCreationFailedFaultType;
import org.oasis_open.docs.wsn.b_2.SubscribeResponse;
import org.oasis_open.docs.wsn.br_2.PublisherRegistrationFailedFaultType;
import org.oasis_open.docs.wsn.br_2.RegisterPublisher;
import org.oasis_open.docs.wsn.br_2.RegisterPublisherResponse;
import org.w3._2005._08.addressing.EndpointReferenceType;

@WebService(endpointInterface="org.apache.servicemix.wsn.jaxws.NotificationBroker")
public abstract class AbstractNotificationBroker
extends AbstractEndpoint
implements NotificationBroker {
    private static Log log = LogFactory.getLog(AbstractNotificationBroker.class);
    private IdGenerator idGenerator = new IdGenerator();
    private AbstractPublisher anonymousPublisher;
    private Map<String, AbstractPublisher> publishers;
    private Map<String, AbstractSubscription> subscriptions = new ConcurrentHashMap<String, AbstractSubscription>();

    public AbstractNotificationBroker(String name) {
        super(name);
        this.publishers = new ConcurrentHashMap<String, AbstractPublisher>();
    }

    public void init() throws Exception {
        this.register();
        this.anonymousPublisher = this.createPublisher("Anonymous");
        this.anonymousPublisher.register();
    }

    public void destroy() throws Exception {
        this.anonymousPublisher.destroy();
        this.unregister();
    }

    protected String createAddress() {
        return "http://servicemix.org/wsnotification/NotificationBroker/" + this.getName();
    }

    @WebMethod(operationName="Notify")
    @Oneway
    public void notify(@WebParam(name="Notify", targetNamespace="http://docs.oasis-open.org/wsn/b-1", partName="Notify") Notify notify) {
        log.debug((Object)"Notify");
        this.handleNotify(notify);
    }

    protected void handleNotify(Notify notify) {
        for (NotificationMessageHolderType messageHolder : notify.getNotificationMessage()) {
            EndpointReferenceType producerReference = messageHolder.getProducerReference();
            AbstractPublisher publisher = this.getPublisher(producerReference);
            if (publisher == null) continue;
            publisher.notify(messageHolder);
        }
    }

    protected AbstractPublisher getPublisher(EndpointReferenceType producerReference) {
        AbstractPublisher publisher = null;
        if (producerReference != null && producerReference.getAddress() != null && producerReference.getAddress().getValue() != null) {
            String address = producerReference.getAddress().getValue();
            publisher = this.publishers.get(address);
        }
        if (publisher == null) {
            publisher = this.anonymousPublisher;
        }
        return publisher;
    }

    @WebMethod(operationName="Subscribe")
    @WebResult(name="SubscribeResponse", targetNamespace="http://docs.oasis-open.org/wsn/b-1", partName="SubscribeResponse")
    public SubscribeResponse subscribe(@WebParam(name="Subscribe", targetNamespace="http://docs.oasis-open.org/wsn/b-1", partName="SubscribeRequest") Subscribe subscribeRequest) throws InvalidFilterFault, InvalidMessageContentExpressionFault, InvalidProducerPropertiesExpressionFault, InvalidTopicExpressionFault, ResourceUnknownFault, SubscribeCreationFailedFault, TopicExpressionDialectUnknownFault, TopicNotSupportedFault, UnacceptableInitialTerminationTimeFault {
        log.debug((Object)"Subscribe");
        return this.handleSubscribe(subscribeRequest, null);
    }

    public SubscribeResponse handleSubscribe(Subscribe subscribeRequest, EndpointManager manager) throws InvalidFilterFault, InvalidMessageContentExpressionFault, InvalidProducerPropertiesExpressionFault, InvalidTopicExpressionFault, SubscribeCreationFailedFault, TopicExpressionDialectUnknownFault, TopicNotSupportedFault, UnacceptableInitialTerminationTimeFault {
        AbstractSubscription subscription = null;
        boolean success = false;
        try {
            subscription = this.createSubcription(this.idGenerator.generateSanitizedId());
            subscription.setBroker(this);
            this.subscriptions.put(subscription.getAddress(), subscription);
            subscription.create(subscribeRequest);
            if (manager != null) {
                subscription.setManager(manager);
            }
            subscription.register();
            SubscribeResponse response = new SubscribeResponse();
            response.setSubscriptionReference(AbstractNotificationBroker.createEndpointReference(subscription.getAddress()));
            success = true;
            SubscribeResponse subscribeResponse = response;
            return subscribeResponse;
        }
        catch (EndpointRegistrationException e) {
            SubscribeCreationFailedFaultType fault = new SubscribeCreationFailedFaultType();
            throw new SubscribeCreationFailedFault("Unable to register endpoint", fault, e);
        }
        finally {
            if (!success && subscription != null) {
                this.subscriptions.remove(subscription);
                try {
                    subscription.unsubscribe();
                }
                catch (UnableToDestroySubscriptionFault e) {
                    log.info((Object)"Error destroying subscription", (Throwable)e);
                }
            }
        }
    }

    public void unsubscribe(String address) throws UnableToDestroySubscriptionFault {
        AbstractSubscription subscription = this.subscriptions.remove(address);
        if (subscription != null) {
            subscription.unsubscribe();
        }
    }

    @WebMethod(operationName="GetCurrentMessage")
    @WebResult(name="GetCurrentMessageResponse", targetNamespace="http://docs.oasis-open.org/wsn/b-1", partName="GetCurrentMessageResponse")
    public GetCurrentMessageResponse getCurrentMessage(@WebParam(name="GetCurrentMessage", targetNamespace="http://docs.oasis-open.org/wsn/b-1", partName="GetCurrentMessageRequest") GetCurrentMessage getCurrentMessageRequest) throws InvalidTopicExpressionFault, MultipleTopicsSpecifiedFault, NoCurrentMessageOnTopicFault, ResourceUnknownFault, TopicExpressionDialectUnknownFault, TopicNotSupportedFault {
        log.debug((Object)"GetCurrentMessage");
        NoCurrentMessageOnTopicFaultType fault = new NoCurrentMessageOnTopicFaultType();
        throw new NoCurrentMessageOnTopicFault("There is no current message on this topic.", fault);
    }

    @WebMethod(operationName="RegisterPublisher")
    @WebResult(name="RegisterPublisherResponse", targetNamespace="http://docs.oasis-open.org/wsn/br-1", partName="RegisterPublisherResponse")
    public RegisterPublisherResponse registerPublisher(@WebParam(name="RegisterPublisher", targetNamespace="http://docs.oasis-open.org/wsn/br-1", partName="RegisterPublisherRequest") RegisterPublisher registerPublisherRequest) throws InvalidTopicExpressionFault, PublisherRegistrationFailedFault, PublisherRegistrationRejectedFault, ResourceUnknownFault, TopicNotSupportedFault {
        log.debug((Object)"RegisterPublisher");
        return this.handleRegisterPublisher(registerPublisherRequest, null);
    }

    public RegisterPublisherResponse handleRegisterPublisher(RegisterPublisher registerPublisherRequest, EndpointManager manager) throws InvalidTopicExpressionFault, PublisherRegistrationFailedFault, PublisherRegistrationRejectedFault, ResourceUnknownFault, TopicNotSupportedFault {
        AbstractPublisher publisher = null;
        boolean success = false;
        try {
            publisher = this.createPublisher(this.idGenerator.generateSanitizedId());
            this.publishers.put(publisher.getAddress(), publisher);
            if (manager != null) {
                publisher.setManager(manager);
            }
            publisher.register();
            publisher.create(registerPublisherRequest);
            RegisterPublisherResponse response = new RegisterPublisherResponse();
            response.setPublisherRegistrationReference(AbstractNotificationBroker.createEndpointReference(publisher.getAddress()));
            success = true;
            RegisterPublisherResponse registerPublisherResponse = response;
            return registerPublisherResponse;
        }
        catch (EndpointRegistrationException e) {
            PublisherRegistrationFailedFaultType fault = new PublisherRegistrationFailedFaultType();
            throw new PublisherRegistrationFailedFault("Unable to register new endpoint", fault, e);
        }
        finally {
            if (!success && publisher != null) {
                this.publishers.remove(publisher.getAddress());
                try {
                    publisher.destroy();
                }
                catch (ResourceNotDestroyedFault e) {
                    log.info((Object)"Error destroying publisher", (Throwable)e);
                }
            }
        }
    }

    protected abstract AbstractPublisher createPublisher(String var1);

    protected abstract AbstractSubscription createSubcription(String var1);
}

