/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.component;

import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.servicemix.common.BaseComponent;
import org.apache.servicemix.common.BaseLifeCycle;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.wsn.EndpointManager;
import org.apache.servicemix.wsn.EndpointRegistrationException;
import org.apache.servicemix.wsn.component.WSNConfiguration;
import org.apache.servicemix.wsn.component.WSNEndpoint;
import org.apache.servicemix.wsn.jbi.JbiNotificationBroker;
import org.apache.servicemix.wsn.jms.JmsCreatePullPoint;

public class WSNLifeCycle
extends BaseLifeCycle {
    private JbiNotificationBroker notificationBroker;
    private JmsCreatePullPoint createPullPoint;
    private WSNConfiguration configuration = new WSNConfiguration();
    private ConnectionFactory connectionFactory;
    private ServiceUnit serviceUnit = new ServiceUnit();

    public WSNLifeCycle(BaseComponent component) {
        super((ServiceMixComponent)component);
        this.serviceUnit.setComponent((ServiceMixComponent)component);
    }

    protected Object getExtensionMBean() throws Exception {
        return this.configuration;
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.configuration.setRootDir(this.context.getWorkspaceRoot());
        this.configuration.load();
        this.notificationBroker = new JbiNotificationBroker(this.configuration.getBrokerName());
        this.notificationBroker.setLifeCycle(this);
        this.notificationBroker.setManager(new WSNEndpointManager());
        if (this.connectionFactory == null) {
            this.connectionFactory = this.lookupConnectionFactory();
        }
        this.notificationBroker.setConnectionFactory(this.connectionFactory);
        this.notificationBroker.init();
        this.createPullPoint = new JmsCreatePullPoint(this.configuration.getBrokerName());
        this.createPullPoint.setManager(new WSNEndpointManager());
        if (this.connectionFactory == null) {
            this.connectionFactory = this.lookupConnectionFactory();
        }
        this.createPullPoint.setConnectionFactory(this.connectionFactory);
        this.createPullPoint.init();
    }

    protected void doShutDown() throws Exception {
        this.notificationBroker.destroy();
        this.createPullPoint.destroy();
        super.doShutDown();
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public WSNConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(WSNConfiguration configuration) {
        this.configuration = configuration;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    protected ConnectionFactory lookupConnectionFactory() throws NamingException {
        Properties props = new Properties();
        if (this.configuration.getInitialContextFactory() != null && this.configuration.getJndiProviderURL() != null) {
            props.put("java.naming.factory.initial", this.configuration.getInitialContextFactory());
            props.put("java.naming.provider.url", this.configuration.getJndiProviderURL());
        }
        InitialContext ctx = new InitialContext(props);
        return (ConnectionFactory)ctx.lookup(this.configuration.getJndiConnectionFactoryName());
    }

    public JbiNotificationBroker getNotificationBroker() {
        return this.notificationBroker;
    }

    public JmsCreatePullPoint getCreatePullPoint() {
        return this.createPullPoint;
    }

    public class WSNEndpointManager
    implements EndpointManager {
        public Object register(String address, Object service) throws EndpointRegistrationException {
            try {
                WSNEndpoint endpoint = new WSNEndpoint(address, service);
                endpoint.setServiceUnit(WSNLifeCycle.this.serviceUnit);
                WSNLifeCycle.this.serviceUnit.addEndpoint((Endpoint)endpoint);
                WSNLifeCycle.this.component.getRegistry().registerEndpoint((Endpoint)endpoint);
                endpoint.activate();
                return endpoint;
            }
            catch (Exception e) {
                throw new EndpointRegistrationException("Unable to activate endpoint", e);
            }
        }

        public void unregister(Object endpoint) throws EndpointRegistrationException {
            try {
                WSNLifeCycle.this.serviceUnit.getEndpoints().remove(endpoint);
                WSNLifeCycle.this.component.getRegistry().unregisterEndpoint((Endpoint)((WSNEndpoint)((Object)endpoint)));
                ((WSNEndpoint)((Object)endpoint)).deactivate();
            }
            catch (Exception e) {
                throw new EndpointRegistrationException("Unable to activate endpoint", e);
            }
        }
    }
}

