/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import org.apache.activemq.util.IdGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.apache.servicemix.wsn.AbstractEndpoint;
import org.apache.servicemix.wsn.AbstractPullPoint;
import org.apache.servicemix.wsn.EndpointManager;
import org.apache.servicemix.wsn.EndpointRegistrationException;
import org.apache.servicemix.wsn.client.AbstractWSAClient;
import org.oasis_open.docs.wsn.b_2.CreatePullPoint;
import org.oasis_open.docs.wsn.b_2.CreatePullPointResponse;
import org.oasis_open.docs.wsn.b_2.UnableToCreatePullPointFaultType;
import org.oasis_open.docs.wsn.bw_2.UnableToCreatePullPointFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroyPullPointFault;
import org.w3c.dom.Element;

@WebService(endpointInterface="org.oasis_open.docs.wsn.bw_2.CreatePullPoint")
public abstract class AbstractCreatePullPoint
extends AbstractEndpoint
implements org.oasis_open.docs.wsn.bw_2.CreatePullPoint {
    private static Log log = LogFactory.getLog(AbstractCreatePullPoint.class);
    private IdGenerator idGenerator = new IdGenerator();
    private Map<String, AbstractPullPoint> pullPoints = new ConcurrentHashMap<String, AbstractPullPoint>();

    public AbstractCreatePullPoint(String name) {
        super(name);
    }

    public void init() throws Exception {
        this.register();
    }

    public void destroy() throws Exception {
        this.unregister();
    }

    protected String createAddress() {
        return "http://servicemix.org/wsnotification/CreatePullPoint/" + this.getName();
    }

    @WebMethod(operationName="CreatePullPoint")
    @WebResult(name="CreatePullPointResponse", targetNamespace="http://docs.oasis-open.org/wsn/b-2", partName="CreatePullPointResponse")
    public CreatePullPointResponse createPullPoint(@WebParam(name="CreatePullPoint", targetNamespace="http://docs.oasis-open.org/wsn/b-2", partName="CreatePullPointRequest") CreatePullPoint createPullPointRequest) throws UnableToCreatePullPointFault {
        log.debug((Object)"CreatePullEndpoint");
        return this.handleCreatePullPoint(createPullPointRequest, null);
    }

    public CreatePullPointResponse handleCreatePullPoint(CreatePullPoint createPullPointRequest, EndpointManager manager) throws UnableToCreatePullPointFault {
        AbstractPullPoint pullPoint = null;
        boolean success = false;
        try {
            Object el2;
            pullPoint = this.createPullPoint(this.idGenerator.generateSanitizedId());
            for (Object el2 : createPullPointRequest.getAny()) {
                if (!"address".equals(el2.getLocalName()) || !"http://servicemix.apache.org/wsn2005/1.0".equals(el2.getNamespaceURI())) continue;
                String address = DOMUtil.getElementText((Element)el2).trim();
                pullPoint.setAddress(address);
            }
            pullPoint.setCreatePullPoint(this);
            this.pullPoints.put(pullPoint.getAddress(), pullPoint);
            pullPoint.create(createPullPointRequest);
            if (manager != null) {
                pullPoint.setManager(manager);
            }
            pullPoint.register();
            CreatePullPointResponse response = new CreatePullPointResponse();
            response.setPullPoint(AbstractWSAClient.createWSA(pullPoint.getAddress()));
            success = true;
            el2 = response;
            return el2;
        }
        catch (EndpointRegistrationException e) {
            UnableToCreatePullPointFaultType fault = new UnableToCreatePullPointFaultType();
            throw new UnableToCreatePullPointFault("Unable to register new endpoint", fault, e);
        }
        finally {
            if (!success && pullPoint != null) {
                this.pullPoints.remove(pullPoint.getAddress());
                try {
                    pullPoint.destroy();
                }
                catch (UnableToDestroyPullPointFault e) {
                    log.info((Object)"Error destroying pullPoint", (Throwable)e);
                }
            }
        }
    }

    public void destroyPullPoint(String address) throws UnableToDestroyPullPointFault {
        AbstractPullPoint pullPoint = this.pullPoints.remove(address);
        if (pullPoint != null) {
            pullPoint.destroy();
        }
    }

    protected abstract AbstractPullPoint createPullPoint(String var1);
}

