/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.client;

import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.servicemix.client.DefaultServiceMixClient;
import org.apache.servicemix.client.ServiceMixClient;
import org.apache.servicemix.client.ServiceMixClientFacade;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.jbi.messaging.PojoMarshaler;
import org.apache.servicemix.jbi.resolver.EndpointResolver;
import org.apache.servicemix.jbi.resolver.ServiceAndEndpointNameResolver;
import org.apache.servicemix.jbi.resolver.URIResolver;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.apache.servicemix.wsn.client.JAXBMarshaler;
import org.oasis_open.docs.wsn.b_2.Subscribe;
import org.oasis_open.docs.wsn.br_2.RegisterPublisher;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractWSAClient {
    private W3CEndpointReference endpoint;
    private EndpointResolver resolver;
    private ServiceMixClient client;

    public AbstractWSAClient() {
    }

    public AbstractWSAClient(W3CEndpointReference endpoint, ServiceMixClient client) {
        this.endpoint = endpoint;
        this.resolver = AbstractWSAClient.resolveWSA(endpoint);
        this.client = client;
    }

    public static W3CEndpointReference createWSA(String address) {
        StringSource src = new StringSource("<EndpointReference xmlns='http://www.w3.org/2005/08/addressing'><Address>" + address + "</Address></EndpointReference>");
        return new W3CEndpointReference((Source)src);
    }

    public static String getWSAAddress(W3CEndpointReference ref) {
        try {
            Element element = new SourceTransformer().createDocument().createElement("elem");
            ref.writeTo((Result)new DOMResult(element));
            NodeList nl = element.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "Address");
            if (nl != null && nl.getLength() > 0) {
                Element e = (Element)nl.item(0);
                return DOMUtil.getElementText((Element)e).trim();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return null;
    }

    public static ServiceMixClient createJaxbClient(JBIContainer container) throws JBIException, JAXBException {
        DefaultServiceMixClient client = new DefaultServiceMixClient(container);
        client.setMarshaler((PojoMarshaler)new JAXBMarshaler(JAXBContext.newInstance((Class[])new Class[]{Subscribe.class, RegisterPublisher.class})));
        return client;
    }

    public static ServiceMixClient createJaxbClient(ComponentContext context) throws JAXBException {
        ServiceMixClientFacade client = new ServiceMixClientFacade(context);
        client.setMarshaler((PojoMarshaler)new JAXBMarshaler(JAXBContext.newInstance((Class[])new Class[]{Subscribe.class, RegisterPublisher.class})));
        return client;
    }

    public static EndpointResolver resolveWSA(W3CEndpointReference ref) {
        String[] parts = URIResolver.split3((String)AbstractWSAClient.getWSAAddress(ref));
        return new ServiceAndEndpointNameResolver(new QName(parts[0], parts[1]), parts[2]);
    }

    public W3CEndpointReference getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(W3CEndpointReference endpoint) {
        this.endpoint = endpoint;
    }

    public EndpointResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(EndpointResolver resolver) {
        this.resolver = resolver;
    }

    public ServiceMixClient getClient() {
        return this.client;
    }

    public void setClient(ServiceMixClient client) {
        this.client = client;
    }

    protected Object request(Object request) throws JBIException {
        return this.client.request(this.resolver, null, null, request);
    }

    protected void send(Object request) throws JBIException {
        this.client.sendSync(this.resolver, null, null, request);
    }
}

