/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.component;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.jms.ConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.BaseServiceUnitManager;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.Deployer;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.tools.wsdl.WSDLFlattener;
import org.apache.servicemix.wsn.EndpointManager;
import org.apache.servicemix.wsn.EndpointRegistrationException;
import org.apache.servicemix.wsn.component.WSNConfiguration;
import org.apache.servicemix.wsn.component.WSNDeployer;
import org.apache.servicemix.wsn.component.WSNEndpoint;
import org.apache.servicemix.wsn.jbi.JbiNotificationBroker;
import org.apache.servicemix.wsn.jms.JmsCreatePullPoint;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;

public class WSNComponent
extends DefaultComponent {
    private WSDLFlattener flattener;
    private Map<QName, Document> descriptions;
    private JbiNotificationBroker notificationBroker;
    private JmsCreatePullPoint createPullPoint;
    private WSNConfiguration configuration = new WSNConfiguration();
    private ConnectionFactory connectionFactory;
    private Resource[] resources;
    private Object[] requests;
    private List<Endpoint> endpoints;
    private WSNDeployer deployer;

    public WSNComponent() {
        this.serviceUnit = new ServiceUnit();
        this.serviceUnit.setComponent(this.component);
    }

    public JbiNotificationBroker getNotificationBroker() {
        return this.notificationBroker;
    }

    public JmsCreatePullPoint getCreatePullPoint() {
        return this.createPullPoint;
    }

    protected Object getExtensionMBean() throws Exception {
        return this.configuration;
    }

    public BaseServiceUnitManager createServiceUnitManager() {
        this.deployer = new WSNDeployer((ServiceMixComponent)this);
        return new BaseServiceUnitManager((ServiceMixComponent)this, new Deployer[]{this.deployer});
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    protected List getConfiguredEndpoints() {
        return this.endpoints;
    }

    protected Class[] getEndpointClasses() {
        return new Class[]{WSNEndpoint.class, WSNDeployer.WSNPublisherEndpoint.class, WSNDeployer.WSNPullPointEndpoint.class, WSNDeployer.WSNSubscriptionEndpoint.class};
    }

    public Resource[] getResources() {
        return this.resources;
    }

    public void setResources(Resource[] resources) {
        this.resources = resources;
    }

    public Object[] getRequests() {
        return this.requests;
    }

    public void setRequests(Object[] requests) {
        this.requests = requests;
    }

    protected void doInit() throws Exception {
        Endpoint ep;
        int i;
        this.configuration.setRootDir(this.context.getWorkspaceRoot());
        this.configuration.load();
        this.notificationBroker = new JbiNotificationBroker(this.configuration.getBrokerName());
        this.notificationBroker.setManager(new WSNEndpointManager());
        if (this.connectionFactory == null) {
            this.connectionFactory = this.lookupConnectionFactory();
        }
        this.notificationBroker.setConnectionFactory(this.connectionFactory);
        this.notificationBroker.init();
        this.createPullPoint = new JmsCreatePullPoint(this.configuration.getBrokerName());
        this.createPullPoint.setManager(new WSNEndpointManager());
        if (this.connectionFactory == null) {
            this.connectionFactory = this.lookupConnectionFactory();
        }
        this.createPullPoint.setConnectionFactory(this.connectionFactory);
        this.createPullPoint.init();
        this.endpoints = new ArrayList<Endpoint>();
        if (this.resources != null) {
            for (i = 0; i < this.resources.length; ++i) {
                ep = this.deployer.createEndpoint(this.resources[i].getURL());
                this.endpoints.add(ep);
            }
        }
        if (this.requests != null) {
            for (i = 0; i < this.requests.length; ++i) {
                ep = this.deployer.createEndpoint(this.requests[i]);
                this.endpoints.add(ep);
            }
        }
        super.doInit();
    }

    protected void doShutDown() throws Exception {
        this.notificationBroker.destroy();
        this.createPullPoint.destroy();
        super.doShutDown();
    }

    public Document getServiceDescription(ServiceEndpoint endpoint) {
        String key;
        Endpoint ep;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Querying service description for " + endpoint));
        }
        if ((ep = this.registry.getEndpoint(key = EndpointSupport.getKey((ServiceEndpoint)endpoint))) != null) {
            QName interfaceName = ep.getInterfaceName();
            if (interfaceName == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Could not retrieve description for endpoint " + key + " (no interface defined)"));
                }
                return null;
            }
            return this.getDescription(interfaceName);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No endpoint found for " + key));
        }
        return null;
    }

    private synchronized Document getDescription(QName interfaceName) {
        try {
            Document doc;
            if (this.descriptions == null) {
                this.descriptions = new HashMap<QName, Document>();
            }
            if ((doc = this.descriptions.get(interfaceName)) == null) {
                if (this.flattener == null) {
                    URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/apache/servicemix/wsn/wsn.wsdl");
                    WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
                    reader.setFeature("javax.wsdl.verbose", false);
                    Definition definition = reader.readWSDL(null, resource.toString());
                    this.flattener = new WSDLFlattener(definition);
                }
                Definition flatDef = this.flattener.getDefinition(interfaceName);
                doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(flatDef);
                this.descriptions.put(interfaceName, doc);
            }
            return doc;
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Error retrieving endpoint description", (Throwable)e);
            }
            return null;
        }
    }

    protected ConnectionFactory lookupConnectionFactory() throws NamingException {
        Properties props = new Properties();
        if (this.configuration.getInitialContextFactory() != null && this.configuration.getJndiProviderURL() != null) {
            props.put("java.naming.factory.initial", this.configuration.getInitialContextFactory());
            props.put("java.naming.provider.url", this.configuration.getJndiProviderURL());
        }
        InitialContext ctx = new InitialContext(props);
        return (ConnectionFactory)ctx.lookup(this.configuration.getJndiConnectionFactoryName());
    }

    public class WSNEndpointManager
    implements EndpointManager {
        public Object register(String address, Object service) throws EndpointRegistrationException {
            try {
                WSNEndpoint endpoint = new WSNEndpoint(address, service);
                WSNComponent.this.addEndpoint((Endpoint)endpoint);
                return endpoint;
            }
            catch (Exception e) {
                throw new EndpointRegistrationException("Unable to activate endpoint", e);
            }
        }

        public void unregister(Object endpoint) throws EndpointRegistrationException {
            try {
                WSNComponent.this.removeEndpoint((Endpoint)endpoint);
            }
            catch (Exception e) {
                throw new EndpointRegistrationException("Unable to activate endpoint", e);
            }
        }
    }
}

