/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.component;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.WebFault;
import org.apache.servicemix.common.ExchangeProcessor;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.jbi.resolver.URIResolver;
import org.apache.servicemix.wsn.ComponentContextAware;
import org.oasis_open.docs.wsrf.bf_2.BaseFaultType;

public class WSNEndpoint
extends ProviderEndpoint
implements ExchangeProcessor {
    protected String address;
    protected Object pojo;
    protected JAXBContext jaxbContext;
    protected Class endpointInterface;

    public WSNEndpoint(String address, Object pojo) {
        this.address = address;
        this.pojo = pojo;
        String[] parts = URIResolver.split3((String)address);
        this.service = new QName(parts[0], parts[1]);
        this.endpoint = parts[2];
    }

    public void start() throws Exception {
        if (this.pojo instanceof ComponentContextAware) {
            ((ComponentContextAware)this.pojo).setContext(this.getContext());
        }
        this.logger = this.serviceUnit.getComponent().getLogger();
        WebService ws = this.getWebServiceAnnotation(this.pojo.getClass());
        if (ws == null) {
            throw new IllegalStateException("Unable to find WebService annotation");
        }
        this.endpointInterface = Class.forName(ws.endpointInterface());
        this.jaxbContext = WSNEndpoint.createJAXBContext(this.endpointInterface);
        ws = this.getWebServiceAnnotation(this.endpointInterface);
        if (ws != null) {
            this.interfaceName = new QName(ws.targetNamespace(), ws.name());
        }
        super.start();
    }

    public static JAXBContext createJAXBContext(Class interfaceClass) throws JAXBException {
        ArrayList classes = new ArrayList();
        classes.add(JbiFault.class);
        for (Method mth : interfaceClass.getMethods()) {
            WebMethod wm = mth.getAnnotation(WebMethod.class);
            if (wm == null) continue;
            classes.add(mth.getReturnType());
            classes.addAll(Arrays.asList(mth.getParameterTypes()));
        }
        return JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]));
    }

    public void process(MessageExchange exchange) throws Exception {
        Object output;
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        Object input = this.jaxbContext.createUnmarshaller().unmarshal(exchange.getMessage("in").getContent());
        Method webMethod = null;
        for (Method mth : this.endpointInterface.getMethods()) {
            Class<?>[] params = mth.getParameterTypes();
            if (params.length != 1 || !params[0].isAssignableFrom(input.getClass())) continue;
            webMethod = mth;
            break;
        }
        if (webMethod == null) {
            throw new IllegalStateException("Could not determine invoked web method");
        }
        boolean oneWay = webMethod.getAnnotation(Oneway.class) != null;
        try {
            output = webMethod.invoke(this.pojo, input);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                WebFault fa = e.getCause().getClass().getAnnotation(WebFault.class);
                if (!(exchange instanceof InOnly) && fa != null) {
                    BaseFaultType info = (BaseFaultType)e.getCause().getClass().getMethod("getFaultInfo", new Class[0]).invoke((Object)e.getCause(), new Object[0]);
                    Fault fault = exchange.createFault();
                    exchange.setFault(fault);
                    exchange.setError((Exception)e.getCause());
                    StringWriter writer = new StringWriter();
                    this.jaxbContext.createMarshaller().marshal((Object)new JbiFault(info), (Writer)writer);
                    fault.setContent((Source)new StringSource(writer.toString()));
                    this.send(exchange);
                    return;
                }
                throw (Exception)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        if (oneWay) {
            exchange.setStatus(ExchangeStatus.DONE);
            this.send(exchange);
        } else {
            NormalizedMessage msg = exchange.createMessage();
            exchange.setMessage(msg, "out");
            StringWriter writer = new StringWriter();
            this.jaxbContext.createMarshaller().marshal(output, (Writer)writer);
            msg.setContent((Source)new StringSource(writer.toString()));
            this.send(exchange);
        }
    }

    protected Method getWebServiceMethod(QName interfaceName, QName operation) throws Exception {
        WebService ws = this.getWebServiceAnnotation(this.pojo.getClass());
        if (ws == null) {
            throw new IllegalStateException("Unable to find WebService annotation");
        }
        Class<?> itf = Class.forName(ws.endpointInterface());
        for (Method mth : itf.getMethods()) {
            WebMethod wm = mth.getAnnotation(WebMethod.class);
            if (wm == null) continue;
        }
        return null;
    }

    protected WebService getWebServiceAnnotation(Class clazz) {
        for (Class cl = clazz; cl != null; cl = cl.getSuperclass()) {
            WebService ws = cl.getAnnotation(WebService.class);
            if (ws == null) continue;
            return ws;
        }
        return null;
    }

    @XmlRootElement(name="Fault")
    public static class JbiFault {
        private BaseFaultType info;

        public JbiFault() {
        }

        public JbiFault(BaseFaultType info) {
            this.info = info;
        }

        public BaseFaultType getInfo() {
            return this.info;
        }

        public void setInfo(BaseFaultType info) {
            this.info = info;
        }
    }
}

