/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.journal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import org.apache.activeio.journal.InvalidRecordLocationException;
import org.apache.activeio.journal.Journal;
import org.apache.activeio.journal.JournalEventListener;
import org.apache.activeio.journal.JournalStatsFilter;
import org.apache.activeio.journal.RecordLocation;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.Packet;

public abstract class JournalPerfToolSupport
implements JournalEventListener {
    private JournalStatsFilter journal;
    private Random random = new Random();
    private byte[] data;
    private int workerCount = 0;
    private PrintWriter statWriter;
    protected File journalDirectory = new File("journal-logs");
    protected File statCSVFile = new File("stats.csv");
    protected int workerIncrement = 5;
    protected long incrementDelay = 20000L;
    protected boolean verbose = true;
    protected int initialWorkers = 10;
    protected int recordSize = 1024;
    protected int syncFrequency = 15;
    protected int workerThinkTime = 100;

    protected void exec() throws Exception {
        int i;
        System.out.println("Client threads write records using: Record Size: " + this.recordSize + ", Sync Frequency: " + this.syncFrequency + ", Worker Think Time: " + this.workerThinkTime);
        this.data = new byte[this.recordSize];
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)i;
        }
        if (this.statCSVFile != null) {
            this.statWriter = new PrintWriter(new FileOutputStream(this.statCSVFile));
            this.statWriter.println("Threads,Throughput (k/s),Forcd write latency (ms),Throughput (records/s)");
        }
        if (this.journalDirectory.exists()) {
            JournalPerfToolSupport.deleteDir(this.journalDirectory);
        }
        this.journal = new JournalStatsFilter(this.createJournal()).enableDetailedStats(this.verbose);
        this.journal.setJournalEventListener(this);
        try {
            System.out.println("Starting " + this.initialWorkers + " Workers...");
            for (i = 0; i < this.initialWorkers; ++i) {
                new Thread(new Worker()).start();
                ++this.workerCount;
            }
            block4: while (true) {
                System.out.println("Waiting " + this.incrementDelay / 1000L + " seconds before next Stat sample.");
                Thread.sleep(this.incrementDelay);
                this.displayStats();
                this.journal.reset();
                System.out.println("Starting " + this.workerIncrement + " Workers...");
                i = 0;
                while (true) {
                    if (i >= this.workerIncrement) continue block4;
                    new Thread(new Worker()).start();
                    ++this.workerCount;
                    ++i;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            this.journal.close();
            throw throwable;
        }
    }

    private void displayStats() {
        System.out.println("Stats at " + this.workerCount + " workers.");
        System.out.println(this.journal);
        if (this.statWriter != null) {
            this.statWriter.println("" + this.workerCount + "," + this.journal.getWriteThroughputKps() + "," + this.journal.getAvgSyncedLatencyMs() + "," + this.journal.getWriteThroughputRps());
            this.statWriter.flush();
        }
    }

    public abstract Journal createJournal() throws Exception;

    private static void deleteDir(File f) {
        File[] files = f.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            file.delete();
        }
        f.delete();
    }

    public void overflowNotification(RecordLocation safeLocation) {
        try {
            this.journal.setMark(safeLocation, false);
        }
        catch (InvalidRecordLocationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final class Worker
    implements Runnable {
        private Worker() {
        }

        public void run() {
            int i = JournalPerfToolSupport.this.random.nextInt() % JournalPerfToolSupport.this.syncFrequency;
            while (true) {
                boolean sync = false;
                if (JournalPerfToolSupport.this.syncFrequency >= 0 && i % JournalPerfToolSupport.this.syncFrequency == 0) {
                    sync = true;
                }
                try {
                    JournalPerfToolSupport.this.journal.write((Packet)new ByteArrayPacket(JournalPerfToolSupport.this.data), sync);
                    Thread.sleep(JournalPerfToolSupport.this.workerThinkTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                ++i;
            }
        }
    }
}

