/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Converter;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.jaxp.StringSource;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.converter.stream.StreamCache;

@Converter
public class StreamCacheConverter {
    private XmlConverter converter = new XmlConverter();

    @Converter
    public StreamCache convertToStreamCache(StreamSource source) throws TransformerException {
        return new StreamSourceCache(this.converter.toString(source));
    }

    @Converter
    public StreamCache convertToStreamCache(InputStream stream) throws IOException {
        return new InputStreamCache(IOConverter.toBytes(stream));
    }

    private class InputStreamCache
    extends ByteArrayInputStream
    implements StreamCache {
        public InputStreamCache(byte[] data) {
            super(data);
        }
    }

    private class StreamSourceCache
    extends StringSource
    implements StreamCache {
        private static final long serialVersionUID = 4147248494104812945L;

        public StreamSourceCache(String text) {
            super(text);
        }
    }
}

