/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ProducerCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipientList
extends ServiceSupport
implements Processor {
    private final Expression<Exchange> expression;
    private ProducerCache<Exchange> producerCache = new ProducerCache();

    public RecipientList(Expression<Exchange> expression) {
        ObjectHelper.notNull(expression, "expression");
        this.expression = expression;
    }

    public String toString() {
        return "RecipientList[" + this.expression + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Object receipientList = this.expression.evaluate(exchange);
        Iterator iter = ObjectConverter.iterator(receipientList);
        ArrayList<Processor> processors = new ArrayList<Processor>();
        while (iter.hasNext()) {
            Object recipient = iter.next();
            Endpoint<Exchange> endpoint = this.resolveEndpoint(exchange, recipient);
            Producer<Exchange> producer = this.producerCache.getProducer(endpoint);
            processors.add(producer);
        }
        MulticastProcessor mp = new MulticastProcessor(processors, new UseLatestAggregationStrategy());
        mp.process(exchange);
    }

    protected Endpoint<Exchange> resolveEndpoint(Exchange exchange, Object recipient) {
        return ExchangeHelper.resolveEndpoint(exchange, recipient);
    }

    @Override
    protected void doStop() throws Exception {
        this.producerCache.stop();
    }

    @Override
    protected void doStart() throws Exception {
    }
}

