/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.CatchProcessor;
import org.apache.camel.processor.DeadLetterChannel;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TryProcessor
extends ServiceSupport
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(TryProcessor.class);
    private final Processor tryProcessor;
    private final List<CatchProcessor> catchClauses;
    private final Processor finallyProcessor;

    public TryProcessor(Processor tryProcessor, List<CatchProcessor> catchClauses, Processor finallyProcessor) {
        this.tryProcessor = tryProcessor;
        this.catchClauses = catchClauses;
        this.finallyProcessor = finallyProcessor;
    }

    public String toString() {
        String finallyText = this.finallyProcessor == null ? "" : " Finally {" + this.finallyProcessor + "}";
        return "Try {" + this.tryProcessor + "} " + this.catchClauses + finallyText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        Exception unexpected;
        block24: {
            Throwable e = null;
            try {
                this.tryProcessor.process(exchange);
                e = exchange.getException();
                if (e != null && DeadLetterChannel.isFailureHandled(exchange)) {
                    e = null;
                }
            }
            catch (Throwable ex) {
                e = ex;
                exchange.setException(e);
            }
            unexpected = null;
            try {
                if (e != null) {
                    LOG.info((Object)"Caught exception while processing exchange.", e);
                    this.handleException(exchange, e);
                }
            }
            catch (Exception ex) {
                unexpected = ex;
            }
            catch (Throwable ex) {
                unexpected = new RuntimeCamelException(ex);
            }
            finally {
                try {
                    this.processFinally(exchange);
                }
                catch (Exception ex) {
                    unexpected = ex;
                }
                catch (Throwable ex) {
                    unexpected = new RuntimeCamelException(ex);
                }
                if (unexpected == null) break block24;
                LOG.warn((Object)"Caught exception inside processFinally clause.", (Throwable)unexpected);
                throw unexpected;
            }
        }
        if (unexpected != null) {
            LOG.warn((Object)"Caught exception inside handle clause.", (Throwable)unexpected);
            throw unexpected;
        }
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.tryProcessor, this.catchClauses, this.finallyProcessor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.tryProcessor, this.catchClauses, this.finallyProcessor);
    }

    protected void handleException(Exchange exchange, Throwable e) throws Throwable {
        for (CatchProcessor catchClause : this.catchClauses) {
            if (!catchClause.catches(e)) continue;
            Exchange localExchange = exchange.copy();
            localExchange.getIn().setHeader("caught.exception", e);
            localExchange.setException(null);
            catchClause.process(localExchange);
            localExchange.getIn().removeHeader("caught.exception");
            ExchangeHelper.copyResults(exchange, localExchange);
            return;
        }
    }

    protected void processFinally(Exchange exchange) throws Throwable {
        if (this.finallyProcessor != null) {
            Throwable lastException = exchange.getException();
            exchange.setException(null);
            this.finallyProcessor.process(exchange);
            if (exchange.getException() == null) {
                exchange.setException(lastException);
            }
        }
    }
}

