/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import org.apache.activemq.camel.component.ActiveMQConfiguration;
import org.apache.activemq.camel.component.CamelEndpointLoader;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;

public class ActiveMQComponent
extends JmsComponent {
    private boolean exposeAllQueues;
    private CamelEndpointLoader endpointLoader;

    public static ActiveMQComponent activeMQComponent() {
        return new ActiveMQComponent();
    }

    public static ActiveMQComponent activeMQComponent(String brokerURL) {
        ActiveMQComponent answer = new ActiveMQComponent();
        answer.getConfiguration().setBrokerURL(brokerURL);
        return answer;
    }

    public ActiveMQComponent() {
    }

    public ActiveMQComponent(CamelContext context) {
        super(context);
    }

    public ActiveMQComponent(ActiveMQConfiguration configuration) {
        super((JmsConfiguration)configuration);
    }

    public ActiveMQConfiguration getConfiguration() {
        return (ActiveMQConfiguration)super.getConfiguration();
    }

    public void setBrokerURL(String brokerURL) {
        this.getConfiguration().setBrokerURL(brokerURL);
    }

    public boolean isExposeAllQueues() {
        return this.exposeAllQueues;
    }

    public void setExposeAllQueues(boolean exposeAllQueues) {
        this.exposeAllQueues = exposeAllQueues;
    }

    public void setUsePooledConnection(boolean usePooledConnection) {
        this.getConfiguration().setUsePooledConnection(usePooledConnection);
    }

    public void setUseSingleConnection(boolean useSingleConnection) {
        this.getConfiguration().setUseSingleConnection(useSingleConnection);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.isExposeAllQueues()) {
            this.endpointLoader = new CamelEndpointLoader(this.getCamelContext());
            this.endpointLoader.afterPropertiesSet();
        }
    }

    protected void doStop() throws Exception {
        if (this.endpointLoader != null) {
            this.endpointLoader.destroy();
            this.endpointLoader = null;
        }
        super.doStop();
    }

    protected JmsConfiguration createConfiguration() {
        return new ActiveMQConfiguration();
    }
}

