/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.camel.component.JournalComponent;
import org.apache.activemq.kaha.impl.async.AsyncDataManager;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.util.ByteSequence;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalEndpoint
extends DefaultEndpoint<Exchange> {
    private static final transient Log LOG = LogFactory.getLog(JournalEndpoint.class);
    private final File directory;
    private final AtomicReference<DefaultConsumer<Exchange>> consumer = new AtomicReference();
    private final Object activationMutex = new Object();
    private int referenceCount;
    private AsyncDataManager dataManager;
    private Thread thread;
    private Location lastReadLocation;
    private long idleDelay = 1000L;
    private boolean syncProduce = true;
    private boolean syncConsume;

    public JournalEndpoint(String uri, JournalComponent journalComponent, File directory) {
        super(uri, journalComponent.getCamelContext());
        this.directory = directory;
    }

    public boolean isSingleton() {
        return true;
    }

    public File getDirectory() {
        return this.directory;
    }

    public Consumer<Exchange> createConsumer(Processor processor) throws Exception {
        return new DefaultConsumer<Exchange>((Endpoint)this, processor){

            public void start() throws Exception {
                super.start();
                JournalEndpoint.this.activateConsumer(this);
            }

            public void stop() throws Exception {
                JournalEndpoint.this.deactivateConsumer(this);
                super.stop();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementReference() throws IOException {
        Object object = this.activationMutex;
        synchronized (object) {
            --this.referenceCount;
            if (this.referenceCount == 0) {
                LOG.debug((Object)("Closing data manager: " + this.directory));
                LOG.debug((Object)("Last mark at: " + this.lastReadLocation));
                this.dataManager.close();
                this.dataManager = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementReference() throws IOException {
        Object object = this.activationMutex;
        synchronized (object) {
            ++this.referenceCount;
            if (this.referenceCount == 1) {
                LOG.debug((Object)("Opening data manager: " + this.directory));
                this.dataManager = new AsyncDataManager();
                this.dataManager.setDirectory(this.directory);
                this.dataManager.start();
                this.lastReadLocation = this.dataManager.getMark();
                LOG.debug((Object)("Last mark at: " + this.lastReadLocation));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivateConsumer(DefaultConsumer<Exchange> consumer) throws IOException {
        Object object = this.activationMutex;
        synchronized (object) {
            if (this.consumer.get() != consumer) {
                throw new RuntimeCamelException("Consumer was not active.");
            }
            this.consumer.set(null);
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            this.decrementReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activateConsumer(DefaultConsumer<Exchange> consumer) throws IOException {
        Object object = this.activationMutex;
        synchronized (object) {
            if (this.consumer.get() != null) {
                throw new RuntimeCamelException("Consumer already active: journal endpoints only support 1 active consumer");
            }
            this.incrementReference();
            this.consumer.set(consumer);
            this.thread = new Thread(){

                public void run() {
                    JournalEndpoint.this.dispatchToConsumer();
                }
            };
            this.thread.setName("Dipatch thread: " + this.getEndpointUri());
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    protected void dispatchToConsumer() {
        try {
            DefaultConsumer<Exchange> consumer;
            while ((consumer = this.consumer.get()) != null) {
                Location location = this.dataManager.getNextLocation(this.lastReadLocation);
                if (location != null) {
                    ByteSequence read = this.dataManager.read(location);
                    Exchange exchange = this.createExchange();
                    exchange.getIn().setBody((Object)read);
                    exchange.getIn().setHeader("journal", (Object)this.getEndpointUri());
                    exchange.getIn().setHeader("location", (Object)location);
                    consumer.getProcessor().process(exchange);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Consumed record at: " + location));
                    }
                    this.dataManager.setMark(location, this.syncConsume);
                    this.lastReadLocation = location;
                    continue;
                }
                LOG.debug((Object)"Sleeping due to no records being available.");
                Thread.sleep(this.idleDelay);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public Producer<Exchange> createProducer() throws Exception {
        return new DefaultProducer<Exchange>((Endpoint)this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(Exchange exchange) throws Exception {
                JournalEndpoint.this.incrementReference();
                try {
                    byte[] bytes;
                    ByteSequence body = (ByteSequence)exchange.getIn().getBody(ByteSequence.class);
                    if (body == null && (bytes = (byte[])exchange.getIn().getBody(byte[].class)) != null) {
                        body = new ByteSequence(bytes);
                    }
                    if (body == null) {
                        throw new CamelExchangeException("In body message could not be converted to a ByteSequence or a byte array.", exchange);
                    }
                    JournalEndpoint.this.dataManager.write(body, JournalEndpoint.this.syncProduce);
                }
                finally {
                    JournalEndpoint.this.decrementReference();
                }
            }
        };
    }

    public boolean isSyncConsume() {
        return this.syncConsume;
    }

    public void setSyncConsume(boolean syncConsume) {
        this.syncConsume = syncConsume;
    }

    public boolean isSyncProduce() {
        return this.syncProduce;
    }

    public void setSyncProduce(boolean syncProduce) {
        this.syncProduce = syncProduce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOpen() {
        Object object = this.activationMutex;
        synchronized (object) {
            return this.referenceCount > 0;
        }
    }
}

