/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.amq;

import java.io.File;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.PersistenceAdapterFactory;
import org.apache.activemq.store.ReferenceStoreAdapter;
import org.apache.activemq.store.amq.AMQPersistenceAdapter;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.util.IOHelper;

public class AMQPersistenceAdapterFactory
implements PersistenceAdapterFactory {
    private TaskRunnerFactory taskRunnerFactory;
    private File dataDirectory;
    private int journalThreadPriority = 10;
    private String brokerName = "localhost";
    private ReferenceStoreAdapter referenceStoreAdapter;
    private boolean syncOnWrite;
    private boolean persistentIndex = true;
    private boolean useNio = true;
    private int maxFileLength = 0x2000000;

    public PersistenceAdapter createPersistenceAdapter() {
        AMQPersistenceAdapter result = new AMQPersistenceAdapter();
        result.setDirectory(this.getDataDirectory());
        result.setTaskRunnerFactory(this.getTaskRunnerFactory());
        result.setBrokerName(this.getBrokerName());
        result.setSyncOnWrite(this.isSyncOnWrite());
        result.setPersistentIndex(this.isPersistentIndex());
        result.setReferenceStoreAdapter(this.getReferenceStoreAdapter());
        result.setUseNio(this.isUseNio());
        result.setMaxFileLength(this.getMaxFileLength());
        return result;
    }

    public File getDataDirectory() {
        if (this.dataDirectory == null) {
            this.dataDirectory = new File(IOHelper.getDefaultDataDirectory(), IOHelper.toFileSystemSafeName(this.brokerName));
        }
        return this.dataDirectory;
    }

    public void setDataDirectory(File dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public TaskRunnerFactory getTaskRunnerFactory() {
        if (this.taskRunnerFactory == null) {
            this.taskRunnerFactory = new TaskRunnerFactory("AMQPersistenceAdaptor Task", this.journalThreadPriority, true, 1000);
        }
        return this.taskRunnerFactory;
    }

    public void setTaskRunnerFactory(TaskRunnerFactory taskRunnerFactory) {
        this.taskRunnerFactory = taskRunnerFactory;
    }

    public int getJournalThreadPriority() {
        return this.journalThreadPriority;
    }

    public void setJournalThreadPriority(int journalThreadPriority) {
        this.journalThreadPriority = journalThreadPriority;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public ReferenceStoreAdapter getReferenceStoreAdapter() {
        return this.referenceStoreAdapter;
    }

    public void setReferenceStoreAdapter(ReferenceStoreAdapter referenceStoreAdapter) {
        this.referenceStoreAdapter = referenceStoreAdapter;
    }

    public boolean isPersistentIndex() {
        return this.persistentIndex;
    }

    public void setPersistentIndex(boolean persistentIndex) {
        this.persistentIndex = persistentIndex;
    }

    public boolean isSyncOnWrite() {
        return this.syncOnWrite;
    }

    public void setSyncOnWrite(boolean syncOnWrite) {
        this.syncOnWrite = syncOnWrite;
    }

    public boolean isUseNio() {
        return this.useNio;
    }

    public void setUseNio(boolean useNio) {
        this.useNio = useNio;
    }

    public int getMaxFileLength() {
        return this.maxFileLength;
    }

    public void setMaxFileLength(int maxFileLength) {
        this.maxFileLength = maxFileLength;
    }
}

