
package org.apache.servicemix.wsn.jaxws;

import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.oasis_open.docs.wsn.b_2.DestroyPullPointResponse;
import org.oasis_open.docs.wsn.b_2.GetMessagesResponse;

@WebService(name = "PullPoint", targetNamespace = "http://docs.oasis-open.org/wsn/bw-2")
@SOAPBinding(style = SOAPBinding.Style.DOCUMENT, use = SOAPBinding.Use.LITERAL, parameterStyle = SOAPBinding.ParameterStyle.BARE)
public interface PullPoint {


    @WebMethod(operationName = "Notify", action = "")
    @Oneway
    public void notify(
        @WebParam(name = "Notify", targetNamespace = "http://docs.oasis-open.org/wsn/b-2")
        org.oasis_open.docs.wsn.b_2.Notify Notify);

    @WebMethod(operationName = "DestroyPullPoint", action = "")
    @WebResult(name = "DestroyPullPointResponse", targetNamespace = "http://docs.oasis-open.org/wsn/b-2")
    public DestroyPullPointResponse destroyPullPoint(
        @WebParam(name = "DestroyPullPoint", targetNamespace = "http://docs.oasis-open.org/wsn/b-2")
        org.oasis_open.docs.wsn.b_2.DestroyPullPoint DestroyPullPoint)
        throws UnableToDestroyPullPointFault
    ;

    @WebMethod(operationName = "GetMessages", action = "")
    @WebResult(name = "GetMessagesResponse", targetNamespace = "http://docs.oasis-open.org/wsn/b-2")
    public GetMessagesResponse getMessages(
        @WebParam(name = "GetMessages", targetNamespace = "http://docs.oasis-open.org/wsn/b-2")
        org.oasis_open.docs.wsn.b_2.GetMessages GetMessages)
        throws ResourceUnknownFault
    ;

}
