/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn;

import java.util.GregorianCalendar;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.servicemix.wsn.AbstractEndpoint;
import org.apache.servicemix.wsn.AbstractNotificationBroker;
import org.apache.servicemix.wsn.EndpointRegistrationException;
import org.apache.servicemix.wsn.jaxws.InvalidFilterFault;
import org.apache.servicemix.wsn.jaxws.InvalidMessageContentExpressionFault;
import org.apache.servicemix.wsn.jaxws.InvalidProducerPropertiesExpressionFault;
import org.apache.servicemix.wsn.jaxws.InvalidTopicExpressionFault;
import org.apache.servicemix.wsn.jaxws.PausableSubscriptionManager;
import org.apache.servicemix.wsn.jaxws.PauseFailedFault;
import org.apache.servicemix.wsn.jaxws.ResourceUnknownFault;
import org.apache.servicemix.wsn.jaxws.ResumeFailedFault;
import org.apache.servicemix.wsn.jaxws.SubscribeCreationFailedFault;
import org.apache.servicemix.wsn.jaxws.TopicExpressionDialectUnknownFault;
import org.apache.servicemix.wsn.jaxws.TopicNotSupportedFault;
import org.apache.servicemix.wsn.jaxws.UnableToDestroySubscriptionFault;
import org.apache.servicemix.wsn.jaxws.UnacceptableInitialTerminationTimeFault;
import org.apache.servicemix.wsn.jaxws.UnacceptableTerminationTimeFault;
import org.oasis_open.docs.wsn.b_2.InvalidFilterFaultType;
import org.oasis_open.docs.wsn.b_2.InvalidMessageContentExpressionFaultType;
import org.oasis_open.docs.wsn.b_2.InvalidProducerPropertiesExpressionFaultType;
import org.oasis_open.docs.wsn.b_2.InvalidTopicExpressionFaultType;
import org.oasis_open.docs.wsn.b_2.PauseSubscription;
import org.oasis_open.docs.wsn.b_2.PauseSubscriptionResponse;
import org.oasis_open.docs.wsn.b_2.QueryExpressionType;
import org.oasis_open.docs.wsn.b_2.Renew;
import org.oasis_open.docs.wsn.b_2.RenewResponse;
import org.oasis_open.docs.wsn.b_2.ResumeSubscription;
import org.oasis_open.docs.wsn.b_2.ResumeSubscriptionResponse;
import org.oasis_open.docs.wsn.b_2.Subscribe;
import org.oasis_open.docs.wsn.b_2.SubscribeCreationFailedFaultType;
import org.oasis_open.docs.wsn.b_2.TopicExpressionType;
import org.oasis_open.docs.wsn.b_2.UnableToDestroySubscriptionFaultType;
import org.oasis_open.docs.wsn.b_2.UnacceptableInitialTerminationTimeFaultType;
import org.oasis_open.docs.wsn.b_2.UnacceptableTerminationTimeFaultType;
import org.oasis_open.docs.wsn.b_2.Unsubscribe;
import org.oasis_open.docs.wsn.b_2.UnsubscribeResponse;
import org.oasis_open.docs.wsn.b_2.UseRaw;
import org.oasis_open.docs.wsrf.bf_2.BaseFaultType;
import org.w3._2005._08.addressing.EndpointReferenceType;

@WebService(endpointInterface="org.apache.servicemix.wsn.jaxws.PausableSubscriptionManager")
public abstract class AbstractSubscription
extends AbstractEndpoint
implements PausableSubscriptionManager {
    public static final String WSN_URI = "http://docs.oasis-open.org/wsn/b-2";
    public static final String XPATH1_URI = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    public static final QName QNAME_TOPIC_EXPRESSION = new QName("http://docs.oasis-open.org/wsn/b-2", "TopicExpression");
    public static final QName QNAME_PRODUCER_PROPERTIES = new QName("http://docs.oasis-open.org/wsn/b-2", "ProducerProperties");
    public static final QName QNAME_MESSAGE_CONTENT = new QName("http://docs.oasis-open.org/wsn/b-2", "MessageContent");
    public static final QName QNAME_USE_RAW = new QName("http://docs.oasis-open.org/wsn/b-2", "UseRaw");
    protected DatatypeFactory datatypeFactory;
    protected XMLGregorianCalendar terminationTime;
    protected boolean useRaw;
    protected TopicExpressionType topic;
    protected QueryExpressionType contentFilter;
    protected EndpointReferenceType consumerReference;
    protected AbstractNotificationBroker broker;

    public AbstractSubscription(String name) {
        super(name);
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Unable to initialize subscription", e);
        }
    }

    @WebMethod(operationName="Renew")
    @WebResult(name="RenewResponse", targetNamespace="http://docs.oasis-open.org/wsn/b-2", partName="RenewResponse")
    public RenewResponse renew(@WebParam(name="Renew", targetNamespace="http://docs.oasis-open.org/wsn/b-2", partName="RenewRequest") Renew renewRequest) throws ResourceUnknownFault, UnacceptableTerminationTimeFault {
        XMLGregorianCalendar terminationTime = this.validateTerminationTime(renewRequest.getTerminationTime());
        this.renew(terminationTime);
        RenewResponse response = new RenewResponse();
        response.setTerminationTime(terminationTime);
        response.setCurrentTime(this.getCurrentTime());
        return response;
    }

    @WebMethod(operationName="Unsubscribe")
    @WebResult(name="UnsubscribeResponse", targetNamespace="http://docs.oasis-open.org/wsn/b-2", partName="UnsubscribeResponse")
    public UnsubscribeResponse unsubscribe(@WebParam(name="Unsubscribe", targetNamespace="http://docs.oasis-open.org/wsn/b-2", partName="UnsubscribeRequest") Unsubscribe unsubscribeRequest) throws ResourceUnknownFault, UnableToDestroySubscriptionFault {
        this.broker.unsubscribe(this.getAddress());
        return new UnsubscribeResponse();
    }

    @WebMethod(operationName="PauseSubscription")
    @WebResult(name="PauseSubscriptionResponse", targetNamespace="http://docs.oasis-open.org/wsn/b-2", partName="PauseSubscriptionResponse")
    public PauseSubscriptionResponse pauseSubscription(@WebParam(name="PauseSubscription", targetNamespace="http://docs.oasis-open.org/wsn/b-2", partName="PauseSubscriptionRequest") PauseSubscription pauseSubscriptionRequest) throws PauseFailedFault, ResourceUnknownFault {
        this.pause();
        return new PauseSubscriptionResponse();
    }

    @WebMethod(operationName="ResumeSubscription")
    @WebResult(name="ResumeSubscriptionResponse", targetNamespace="http://docs.oasis-open.org/wsn/b-2", partName="ResumeSubscriptionResponse")
    public ResumeSubscriptionResponse resumeSubscription(@WebParam(name="ResumeSubscription", targetNamespace="http://docs.oasis-open.org/wsn/b-2", partName="ResumeSubscriptionRequest") ResumeSubscription resumeSubscriptionRequest) throws ResourceUnknownFault, ResumeFailedFault {
        this.resume();
        return new ResumeSubscriptionResponse();
    }

    protected XMLGregorianCalendar validateInitialTerminationTime(String value) throws UnacceptableInitialTerminationTimeFault {
        XMLGregorianCalendar tt = this.parseTerminationTime(value);
        if (tt == null) {
            UnacceptableInitialTerminationTimeFaultType fault = new UnacceptableInitialTerminationTimeFaultType();
            throw new UnacceptableInitialTerminationTimeFault("Unable to parse initial termination time: '" + value + "'", fault);
        }
        XMLGregorianCalendar ct = this.getCurrentTime();
        int c = tt.compare(ct);
        if (c == -1 || c == 0) {
            UnacceptableInitialTerminationTimeFaultType fault = new UnacceptableInitialTerminationTimeFaultType();
            fault.setMinimumTime(ct);
            throw new UnacceptableInitialTerminationTimeFault("Invalid initial termination time", fault);
        }
        return tt;
    }

    protected XMLGregorianCalendar validateTerminationTime(String value) throws UnacceptableTerminationTimeFault {
        XMLGregorianCalendar tt = this.parseTerminationTime(value);
        if (tt == null) {
            UnacceptableTerminationTimeFaultType fault = new UnacceptableTerminationTimeFaultType();
            throw new UnacceptableTerminationTimeFault("Unable to parse termination time: '" + value + "'", fault);
        }
        XMLGregorianCalendar ct = this.getCurrentTime();
        int c = tt.compare(ct);
        if (c == -1 || c == 0) {
            UnacceptableTerminationTimeFaultType fault = new UnacceptableTerminationTimeFaultType();
            fault.setMinimumTime(ct);
            throw new UnacceptableTerminationTimeFault("Invalid termination time", fault);
        }
        return tt;
    }

    protected XMLGregorianCalendar parseTerminationTime(String value) {
        try {
            Duration d = this.datatypeFactory.newDuration(value);
            XMLGregorianCalendar c = this.getCurrentTime();
            c.add(d);
            return c;
        }
        catch (Exception e) {
            try {
                Duration d = this.datatypeFactory.newDurationDayTime(value);
                XMLGregorianCalendar c = this.getCurrentTime();
                c.add(d);
                return c;
            }
            catch (Exception e2) {
                try {
                    Duration d = this.datatypeFactory.newDurationYearMonth(value);
                    XMLGregorianCalendar c = this.getCurrentTime();
                    c.add(d);
                    return c;
                }
                catch (Exception e3) {
                    try {
                        return this.datatypeFactory.newXMLGregorianCalendar(value);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }
        }
    }

    protected XMLGregorianCalendar getCurrentTime() {
        return this.datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar());
    }

    public XMLGregorianCalendar getTerminationTime() {
        return this.terminationTime;
    }

    public void setTerminationTime(XMLGregorianCalendar terminationTime) {
        this.terminationTime = terminationTime;
    }

    public void create(Subscribe subscribeRequest) throws InvalidFilterFault, InvalidMessageContentExpressionFault, InvalidProducerPropertiesExpressionFault, InvalidTopicExpressionFault, SubscribeCreationFailedFault, TopicExpressionDialectUnknownFault, TopicNotSupportedFault, UnacceptableInitialTerminationTimeFault {
        this.validateSubscription(subscribeRequest);
        this.start();
    }

    protected abstract void start() throws SubscribeCreationFailedFault;

    protected abstract void pause() throws PauseFailedFault;

    protected abstract void resume() throws ResumeFailedFault;

    protected abstract void renew(XMLGregorianCalendar var1) throws UnacceptableTerminationTimeFault;

    protected void unsubscribe() throws UnableToDestroySubscriptionFault {
        try {
            this.unregister();
        }
        catch (EndpointRegistrationException e) {
            UnableToDestroySubscriptionFaultType fault = new UnableToDestroySubscriptionFaultType();
            throw new UnableToDestroySubscriptionFault("Error unregistering endpoint", fault, e);
        }
    }

    protected String createAddress() {
        return "http://servicemix.org/wsnotification/Subscription/" + this.getName();
    }

    protected void validateSubscription(Subscribe subscribeRequest) throws InvalidFilterFault, InvalidMessageContentExpressionFault, InvalidProducerPropertiesExpressionFault, InvalidTopicExpressionFault, SubscribeCreationFailedFault, TopicExpressionDialectUnknownFault, TopicNotSupportedFault, UnacceptableInitialTerminationTimeFault {
        BaseFaultType fault;
        JAXBElement e;
        this.consumerReference = subscribeRequest.getConsumerReference();
        if (subscribeRequest.getInitialTerminationTime() != null && !subscribeRequest.getInitialTerminationTime().isNil() && subscribeRequest.getInitialTerminationTime().getValue() != null) {
            String strTerminationTime = (String)subscribeRequest.getInitialTerminationTime().getValue();
            this.terminationTime = this.validateInitialTerminationTime(strTerminationTime.trim());
        }
        if (subscribeRequest.getFilter() != null) {
            for (Object f : subscribeRequest.getFilter().getAny()) {
                e = null;
                if (f instanceof JAXBElement) {
                    e = (JAXBElement)f;
                    f = e.getValue();
                }
                if (f instanceof TopicExpressionType) {
                    if (!e.getName().equals(QNAME_TOPIC_EXPRESSION)) {
                        InvalidTopicExpressionFaultType fault2 = new InvalidTopicExpressionFaultType();
                        throw new InvalidTopicExpressionFault("Unrecognized TopicExpression: " + e, fault2);
                    }
                    this.topic = (TopicExpressionType)f;
                    continue;
                }
                if (f instanceof QueryExpressionType) {
                    if (e != null && e.getName().equals(QNAME_PRODUCER_PROPERTIES)) {
                        InvalidProducerPropertiesExpressionFaultType fault3 = new InvalidProducerPropertiesExpressionFaultType();
                        throw new InvalidProducerPropertiesExpressionFault("ProducerProperties are not supported", fault3);
                    }
                    if (e != null && e.getName().equals(QNAME_MESSAGE_CONTENT)) {
                        if (this.contentFilter != null) {
                            InvalidMessageContentExpressionFaultType fault4 = new InvalidMessageContentExpressionFaultType();
                            throw new InvalidMessageContentExpressionFault("Only one MessageContent filter can be specified", fault4);
                        }
                        this.contentFilter = (QueryExpressionType)f;
                        if (this.contentFilter.getDialect() != null) continue;
                        this.contentFilter.setDialect(XPATH1_URI);
                        continue;
                    }
                    InvalidFilterFaultType fault5 = new InvalidFilterFaultType();
                    throw new InvalidFilterFault("Unrecognized filter: " + (e != null ? e.getName() : f), fault5);
                }
                InvalidFilterFaultType fault6 = new InvalidFilterFaultType();
                throw new InvalidFilterFault("Unrecognized filter: " + (e != null ? e.getName() : f), fault6);
            }
        }
        if (subscribeRequest.getSubscriptionPolicy() != null) {
            for (Object p : subscribeRequest.getSubscriptionPolicy().getAny()) {
                e = null;
                if (p instanceof JAXBElement) {
                    e = (JAXBElement)p;
                    p = e.getValue();
                }
                if (p instanceof UseRaw) {
                    this.useRaw = true;
                    continue;
                }
                InvalidFilterFaultType fault7 = new InvalidFilterFaultType();
                throw new InvalidFilterFault("Unrecognized policy: " + p, fault7);
            }
        }
        if (this.consumerReference == null) {
            fault = new SubscribeCreationFailedFaultType();
            throw new SubscribeCreationFailedFault("Invalid ConsumerReference: null", (SubscribeCreationFailedFaultType)fault);
        }
        if (this.topic == null) {
            fault = new InvalidFilterFaultType();
            throw new InvalidFilterFault("Must specify a topic to subscribe on", (InvalidFilterFaultType)fault);
        }
        if (this.contentFilter != null && !this.contentFilter.getDialect().equals(XPATH1_URI)) {
            fault = new InvalidMessageContentExpressionFaultType();
            throw new InvalidMessageContentExpressionFault("Unsupported MessageContent dialect: '" + this.contentFilter.getDialect() + "'", (InvalidMessageContentExpressionFaultType)fault);
        }
        if (this.terminationTime != null) {
            fault = new UnacceptableInitialTerminationTimeFaultType();
            throw new UnacceptableInitialTerminationTimeFault("InitialTerminationTime is not supported", (UnacceptableInitialTerminationTimeFaultType)fault);
        }
    }

    public AbstractNotificationBroker getBroker() {
        return this.broker;
    }

    public void setBroker(AbstractNotificationBroker broker) {
        this.broker = broker;
    }
}

