/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.component;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.jms.ConnectionFactory;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.BaseComponent;
import org.apache.servicemix.common.BaseLifeCycle;
import org.apache.servicemix.common.BaseServiceUnitManager;
import org.apache.servicemix.common.Deployer;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.tools.wsdl.WSDLFlattener;
import org.apache.servicemix.wsn.component.WSNDeployer;
import org.apache.servicemix.wsn.component.WSNLifeCycle;
import org.w3c.dom.Document;

public class WSNComponent
extends BaseComponent {
    private WSDLFlattener flattener;
    private Map descriptions;

    protected BaseLifeCycle createLifeCycle() {
        return new WSNLifeCycle(this);
    }

    public BaseServiceUnitManager createServiceUnitManager() {
        Deployer[] deployers = new Deployer[]{new WSNDeployer(this)};
        return new BaseServiceUnitManager((ServiceMixComponent)this, deployers);
    }

    public ConnectionFactory getConnectionFactory() {
        return ((WSNLifeCycle)this.lifeCycle).getConnectionFactory();
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        ((WSNLifeCycle)this.lifeCycle).setConnectionFactory(connectionFactory);
    }

    public Document getServiceDescription(ServiceEndpoint endpoint) {
        String key;
        Endpoint ep;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Querying service description for " + endpoint));
        }
        if ((ep = this.registry.getEndpoint(key = EndpointSupport.getKey((ServiceEndpoint)endpoint))) != null) {
            QName interfaceName = ep.getInterfaceName();
            if (interfaceName == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Could not retrieve description for endpoint " + key + " (no interface defined)"));
                }
                return null;
            }
            Document doc = this.getDescription(interfaceName);
            return doc;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No endpoint found for " + key));
        }
        return null;
    }

    private synchronized Document getDescription(QName interfaceName) {
        try {
            Document doc;
            if (this.descriptions == null) {
                this.descriptions = new HashMap();
            }
            if ((doc = (Document)this.descriptions.get(interfaceName)) == null) {
                if (this.flattener == null) {
                    URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/apache/servicemix/wsn/wsn.wsdl");
                    WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
                    reader.setFeature("javax.wsdl.verbose", false);
                    Definition definition = reader.readWSDL(null, resource.toString());
                    this.flattener = new WSDLFlattener(definition);
                }
                Definition flatDef = this.flattener.getDefinition(interfaceName);
                doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(flatDef);
                this.descriptions.put(interfaceName, doc);
            }
            return doc;
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Error retrieving endpoint description", (Throwable)e);
            }
            return null;
        }
    }
}

