/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.xmpp;

import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.servicemix.xmpp.XMPPComponent;
import org.apache.servicemix.xmpp.XMPPEndpoint;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.packet.Message;

public class GroupChatEndpoint
extends XMPPEndpoint {
    private GroupChat chat;
    private String room;

    public GroupChatEndpoint() {
    }

    public GroupChatEndpoint(XMPPComponent component, ServiceEndpoint serviceEndpoint) {
        super(component, serviceEndpoint);
    }

    public GroupChatEndpoint(XMPPComponent component, ServiceEndpoint serviceEndpoint, String room) {
        super(component, serviceEndpoint);
        this.room = room;
    }

    public void start() throws Exception {
        super.start();
        if (this.chat == null) {
            if (this.room == null) {
                throw new IllegalArgumentException("No room property specified");
            }
            this.chat = this.getConnection().createGroupChat(this.room);
        }
    }

    public void stop() throws Exception {
        if (this.chat != null) {
            this.chat.leave();
            this.chat = null;
        }
        super.stop();
    }

    public GroupChat getChat() {
        return this.chat;
    }

    public void setChat(GroupChat chat) {
        this.chat = chat;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    protected void processInOnly(MessageExchange exchange, NormalizedMessage normalizedMessage) throws Exception {
        Message message = this.chat.createMessage();
        message.setTo(this.room);
        message.setFrom(this.getUser());
        this.getMarshaler().fromNMS(message, exchange, normalizedMessage);
        this.chat.sendMessage(message);
        this.done(exchange);
    }
}

