/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.xmpp;

import java.net.URI;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.servicemix.xmpp.XMPPComponent;
import org.apache.servicemix.xmpp.XMPPEndpoint;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.packet.Message;

public class PrivateChatEndpoint
extends XMPPEndpoint {
    private Chat chat;
    private String participant;

    public PrivateChatEndpoint() {
    }

    public PrivateChatEndpoint(XMPPComponent component, ServiceEndpoint serviceEndpoint) {
        super(component, serviceEndpoint);
    }

    public void start() throws Exception {
        super.start();
        if (this.chat == null) {
            if (this.getParticipant() == null) {
                throw new IllegalArgumentException("No participant property specified");
            }
            this.chat = this.getConnection().createChat(this.getParticipant());
        }
    }

    public void stop() throws Exception {
        this.chat = null;
        super.stop();
    }

    public Chat getChat() {
        return this.chat;
    }

    public void setChat(Chat chat) {
        this.chat = chat;
    }

    public String getParticipant() {
        return this.participant;
    }

    public void setParticipant(String participant) {
        this.participant = participant;
    }

    public void setUri(URI uri) {
        super.setUri(uri);
        String path = uri.getPath();
        if (path != null) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            this.setParticipant(path);
        }
    }

    protected void processInOnly(MessageExchange exchange, NormalizedMessage normalizedMessage) throws Exception {
        Message message = this.chat.createMessage();
        this.getMarshaler().fromNMS(message, exchange, normalizedMessage);
        message.setTo(this.getParticipant());
        message.setFrom(this.getUser());
        message.setThread(exchange.getExchangeId());
        message.setType(Message.Type.NORMAL);
        this.chat.sendMessage(message);
    }
}

