/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.xmpp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.util.IntrospectionSupport;
import org.apache.servicemix.common.util.URISupport;
import org.apache.servicemix.xmpp.GroupChatEndpoint;
import org.apache.servicemix.xmpp.PrivateChatEndpoint;
import org.apache.servicemix.xmpp.XMPPEndpoint;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class XMPPComponent
extends DefaultComponent
implements BeanFactoryAware {
    private XMPPEndpoint[] endpoints;
    private BeanFactory beanFactory;
    private String user;
    private String password;

    public XMPPEndpoint[] getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(XMPPEndpoint[] endpoints) {
        this.endpoints = endpoints;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected List getConfiguredEndpoints() {
        return XMPPComponent.asList((Object[])this.getEndpoints());
    }

    protected Class[] getEndpointClasses() {
        return new Class[]{XMPPEndpoint.class};
    }

    protected Endpoint getResolvedEPR(ServiceEndpoint ep) throws Exception {
        XMPPEndpoint endpoint = this.createEndpoint(ep);
        return endpoint;
    }

    public XMPPEndpoint createEndpoint(ServiceEndpoint ep) throws URISyntaxException {
        URI uri = new URI(ep.getEndpointName());
        Map map = URISupport.parseQuery((String)uri.getQuery());
        XMPPEndpoint endpoint = null;
        String room = (String)map.get("room");
        endpoint = room != null ? new GroupChatEndpoint(this, ep, room) : new PrivateChatEndpoint(this, ep);
        IntrospectionSupport.setProperties((Object)((Object)endpoint), (Map)map);
        IntrospectionSupport.setProperties((Object)endpoint.getMarshaler(), (Map)map, (String)"marshal.");
        endpoint.setUri(uri);
        return endpoint;
    }
}

