/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.xmpp;

import java.net.URI;
import java.util.Iterator;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.xmpp.XMPPComponent;
import org.apache.servicemix.xmpp.XMPPListenerException;
import org.apache.servicemix.xmpp.XMPPMarshaler;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterPacket;

public abstract class XMPPEndpoint
extends ProviderEndpoint
implements PacketListener {
    private XMPPMarshaler marshaler = new XMPPMarshaler();
    private XMPPConnection connection;
    private String host;
    private int port;
    private String user;
    private String password;
    private String resource = "ServiceMix";
    private boolean login = true;
    private PacketFilter filter;
    private boolean createAccount;

    public XMPPEndpoint() {
    }

    public XMPPEndpoint(XMPPComponent component, ServiceEndpoint serviceEndpoint) {
        super((DefaultComponent)component, serviceEndpoint);
        this.init(component);
    }

    public void stop() throws Exception {
        super.stop();
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void start() throws Exception {
        super.start();
        if (this.connection == null) {
            this.connection = this.port > 0 ? new XMPPConnection(this.host, this.port) : new XMPPConnection(this.host);
        }
        this.getConnection().addPacketListener((PacketListener)this, this.filter);
        if (this.login && !this.connection.isAuthenticated()) {
            if (this.user != null) {
                this.logger.info((Object)("Logging in to Jabber as user: " + this.user + " on connection: " + this.connection));
                if (this.password == null) {
                    this.logger.warn((Object)("No password configured for user: " + this.user));
                }
                if (this.createAccount) {
                    AccountManager accountManager = new AccountManager(this.connection);
                    accountManager.createAccount(this.user, this.password);
                }
                if (this.resource != null) {
                    this.connection.login(this.user, this.password, this.resource);
                } else {
                    this.connection.login(this.user, this.password);
                }
            } else {
                this.logger.info((Object)("Logging in anonymously to Jabber on connection: " + this.connection));
                this.connection.loginAnonymously();
            }
            this.connection.sendPacket((Packet)new Presence(Presence.Type.AVAILABLE));
        }
    }

    public void setServiceUnit(ServiceUnit serviceUnit) {
        super.setServiceUnit(serviceUnit);
        this.init((XMPPComponent)serviceUnit.getComponent());
    }

    public void processPacket(Packet packet) {
        try {
            this.logger.debug((Object)("Received packet: " + packet));
            if (this.logger.isDebugEnabled()) {
                Iterator iter = packet.getPropertyNames();
                while (iter.hasNext()) {
                    String property = (String)iter.next();
                    this.logger.debug((Object)("Packet header: " + property + " value: " + packet.getProperty(property)));
                }
            }
            if (packet instanceof Message) {
                Message message = (Message)packet;
                this.logger.debug((Object)("Received message: " + message + " with " + message.getBody()));
            } else if (packet instanceof RosterPacket) {
                RosterPacket rosterPacket = (RosterPacket)packet;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Roster packet with : " + rosterPacket.getRosterItemCount()));
                    Iterator rosterItems = rosterPacket.getRosterItems();
                    while (rosterItems.hasNext()) {
                        Object item = rosterItems.next();
                        this.logger.debug((Object)("Roster item: " + item));
                    }
                }
            }
            InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
            NormalizedMessage in = exchange.createMessage();
            exchange.setInMessage(in);
            this.marshaler.toNMS(in, packet);
            this.logger.debug((Object)("Exchange: " + exchange));
        }
        catch (MessagingException e) {
            throw new XMPPListenerException((Exception)((Object)e), packet);
        }
    }

    public void setUri(URI uri) {
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        if (uri.getUserInfo() != null) {
            this.setUser(uri.getUserInfo());
        }
    }

    public XMPPConnection getConnection() {
        return this.connection;
    }

    public void setConnection(XMPPConnection connection) {
        this.connection = connection;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public XMPPMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(XMPPMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean isLogin() {
        return this.login;
    }

    public void setLogin(boolean login) {
        this.login = login;
    }

    public boolean isCreateAccount() {
        return this.createAccount;
    }

    public void setCreateAccount(boolean createAccount) {
        this.createAccount = createAccount;
    }

    public PacketFilter getFilter() {
        return this.filter;
    }

    public void setFilter(PacketFilter filter) {
        this.filter = filter;
    }

    protected final void init(XMPPComponent component) {
        if (this.user == null) {
            this.user = component.getUser();
        }
        if (this.password == null) {
            this.password = component.getPassword();
        }
    }
}

